@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolAccountRecoverySettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property recoveryMechanisms List of Account Recovery Options of the following structure:
 */
public data class UserPoolAccountRecoverySettingArgs(
    public val recoveryMechanisms: Output<List<UserPoolAccountRecoverySettingRecoveryMechanismArgs>>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolAccountRecoverySettingArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolAccountRecoverySettingArgs =
        com.pulumi.aws.cognito.inputs.UserPoolAccountRecoverySettingArgs.builder()
            .recoveryMechanisms(
                recoveryMechanisms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [UserPoolAccountRecoverySettingArgs].
 */
@PulumiTagMarker
public class UserPoolAccountRecoverySettingArgsBuilder internal constructor() {
    private var recoveryMechanisms: Output<List<UserPoolAccountRecoverySettingRecoveryMechanismArgs>>? =
        null

    /**
     * @param value List of Account Recovery Options of the following structure:
     */
    @JvmName("lgbicjoiykbcgmuu")
    public suspend
    fun recoveryMechanisms(`value`: Output<List<UserPoolAccountRecoverySettingRecoveryMechanismArgs>>) {
        this.recoveryMechanisms = value
    }

    @JvmName("pqyiupkghoqckhcj")
    public suspend fun recoveryMechanisms(
        vararg
        values: Output<UserPoolAccountRecoverySettingRecoveryMechanismArgs>,
    ) {
        this.recoveryMechanisms = Output.all(values.asList())
    }

    /**
     * @param values List of Account Recovery Options of the following structure:
     */
    @JvmName("amgququxpmgqsxiq")
    public suspend
    fun recoveryMechanisms(values: List<Output<UserPoolAccountRecoverySettingRecoveryMechanismArgs>>) {
        this.recoveryMechanisms = Output.all(values)
    }

    /**
     * @param value List of Account Recovery Options of the following structure:
     */
    @JvmName("qyycmmvhjtuxnoyc")
    public suspend
    fun recoveryMechanisms(`value`: List<UserPoolAccountRecoverySettingRecoveryMechanismArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryMechanisms = mapped
    }

    /**
     * @param argument List of Account Recovery Options of the following structure:
     */
    @JvmName("tfrbudakkbfvveba")
    public suspend
    fun recoveryMechanisms(argument: List<suspend UserPoolAccountRecoverySettingRecoveryMechanismArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPoolAccountRecoverySettingRecoveryMechanismArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recoveryMechanisms = mapped
    }

    /**
     * @param argument List of Account Recovery Options of the following structure:
     */
    @JvmName("kmdqmueoomamngdq")
    public suspend fun recoveryMechanisms(
        vararg
        argument: suspend UserPoolAccountRecoverySettingRecoveryMechanismArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            UserPoolAccountRecoverySettingRecoveryMechanismArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recoveryMechanisms = mapped
    }

    /**
     * @param argument List of Account Recovery Options of the following structure:
     */
    @JvmName("fpxqvokutijawero")
    public suspend
    fun recoveryMechanisms(argument: suspend UserPoolAccountRecoverySettingRecoveryMechanismArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                UserPoolAccountRecoverySettingRecoveryMechanismArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.recoveryMechanisms = mapped
    }

    /**
     * @param values List of Account Recovery Options of the following structure:
     */
    @JvmName("vmjoiccekbxtyadg")
    public suspend fun recoveryMechanisms(
        vararg
        values: UserPoolAccountRecoverySettingRecoveryMechanismArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryMechanisms = mapped
    }

    internal fun build(): UserPoolAccountRecoverySettingArgs = UserPoolAccountRecoverySettingArgs(
        recoveryMechanisms = recoveryMechanisms,
    )
}
