@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolAdminCreateUserConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property allowAdminCreateUserOnly Set to True if only the administrator is allowed to create user profiles. Set to False if users can sign themselves up via an app.
 * @property inviteMessageTemplate Invite message template structure. Detailed below.
 */
public data class UserPoolAdminCreateUserConfigArgs(
    public val allowAdminCreateUserOnly: Output<Boolean>? = null,
    public val inviteMessageTemplate: Output<UserPoolAdminCreateUserConfigInviteMessageTemplateArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolAdminCreateUserConfigArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolAdminCreateUserConfigArgs =
        com.pulumi.aws.cognito.inputs.UserPoolAdminCreateUserConfigArgs.builder()
            .allowAdminCreateUserOnly(allowAdminCreateUserOnly?.applyValue({ args0 -> args0 }))
            .inviteMessageTemplate(
                inviteMessageTemplate?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserPoolAdminCreateUserConfigArgs].
 */
@PulumiTagMarker
public class UserPoolAdminCreateUserConfigArgsBuilder internal constructor() {
    private var allowAdminCreateUserOnly: Output<Boolean>? = null

    private var inviteMessageTemplate: Output<UserPoolAdminCreateUserConfigInviteMessageTemplateArgs>? =
        null

    /**
     * @param value Set to True if only the administrator is allowed to create user profiles. Set to False if users can sign themselves up via an app.
     */
    @JvmName("ternbmsefaetvhpj")
    public suspend fun allowAdminCreateUserOnly(`value`: Output<Boolean>) {
        this.allowAdminCreateUserOnly = value
    }

    /**
     * @param value Invite message template structure. Detailed below.
     */
    @JvmName("gspgawwwwdtsmuun")
    public suspend
    fun inviteMessageTemplate(`value`: Output<UserPoolAdminCreateUserConfigInviteMessageTemplateArgs>) {
        this.inviteMessageTemplate = value
    }

    /**
     * @param value Set to True if only the administrator is allowed to create user profiles. Set to False if users can sign themselves up via an app.
     */
    @JvmName("ehnqwjykgnguhpuv")
    public suspend fun allowAdminCreateUserOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowAdminCreateUserOnly = mapped
    }

    /**
     * @param value Invite message template structure. Detailed below.
     */
    @JvmName("pirjqqyhqvfmkqdy")
    public suspend
    fun inviteMessageTemplate(`value`: UserPoolAdminCreateUserConfigInviteMessageTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inviteMessageTemplate = mapped
    }

    /**
     * @param argument Invite message template structure. Detailed below.
     */
    @JvmName("mrjgwppaectuwtdy")
    public suspend
    fun inviteMessageTemplate(argument: suspend UserPoolAdminCreateUserConfigInviteMessageTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolAdminCreateUserConfigInviteMessageTemplateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.inviteMessageTemplate = mapped
    }

    internal fun build(): UserPoolAdminCreateUserConfigArgs = UserPoolAdminCreateUserConfigArgs(
        allowAdminCreateUserOnly = allowAdminCreateUserOnly,
        inviteMessageTemplate = inviteMessageTemplate,
    )
}
