@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolAdminCreateUserConfigInviteMessageTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property emailMessage Message template for email messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
 * @property emailSubject Subject line for email messages.
 * @property smsMessage Message template for SMS messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
 */
public data class UserPoolAdminCreateUserConfigInviteMessageTemplateArgs(
    public val emailMessage: Output<String>? = null,
    public val emailSubject: Output<String>? = null,
    public val smsMessage: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolAdminCreateUserConfigInviteMessageTemplateArgs> {
    override fun toJava():
        com.pulumi.aws.cognito.inputs.UserPoolAdminCreateUserConfigInviteMessageTemplateArgs =
        com.pulumi.aws.cognito.inputs.UserPoolAdminCreateUserConfigInviteMessageTemplateArgs.builder()
            .emailMessage(emailMessage?.applyValue({ args0 -> args0 }))
            .emailSubject(emailSubject?.applyValue({ args0 -> args0 }))
            .smsMessage(smsMessage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolAdminCreateUserConfigInviteMessageTemplateArgs].
 */
@PulumiTagMarker
public class UserPoolAdminCreateUserConfigInviteMessageTemplateArgsBuilder internal constructor() {
    private var emailMessage: Output<String>? = null

    private var emailSubject: Output<String>? = null

    private var smsMessage: Output<String>? = null

    /**
     * @param value Message template for email messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
     */
    @JvmName("tqktkndcodaqcwio")
    public suspend fun emailMessage(`value`: Output<String>) {
        this.emailMessage = value
    }

    /**
     * @param value Subject line for email messages.
     */
    @JvmName("vwayokwpncpbbfbg")
    public suspend fun emailSubject(`value`: Output<String>) {
        this.emailSubject = value
    }

    /**
     * @param value Message template for SMS messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
     */
    @JvmName("dnkiggmgvpmkqsjq")
    public suspend fun smsMessage(`value`: Output<String>) {
        this.smsMessage = value
    }

    /**
     * @param value Message template for email messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
     */
    @JvmName("tgpvsfcgqcifkifu")
    public suspend fun emailMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailMessage = mapped
    }

    /**
     * @param value Subject line for email messages.
     */
    @JvmName("oslpsdrmxonhkgvl")
    public suspend fun emailSubject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailSubject = mapped
    }

    /**
     * @param value Message template for SMS messages. Must contain `{username}` and `{####}` placeholders, for username and temporary password, respectively.
     */
    @JvmName("fbmjokasjfrifmwf")
    public suspend fun smsMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smsMessage = mapped
    }

    internal fun build(): UserPoolAdminCreateUserConfigInviteMessageTemplateArgs =
        UserPoolAdminCreateUserConfigInviteMessageTemplateArgs(
            emailMessage = emailMessage,
            emailSubject = emailSubject,
            smsMessage = smsMessage,
        )
}
