@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property createAuthChallenge ARN of the lambda creating an authentication challenge.
 * @property customEmailSender A custom email sender AWS Lambda trigger. See custom_email_sender Below.
 * @property customMessage Custom Message AWS Lambda trigger.
 * @property customSmsSender A custom SMS sender AWS Lambda trigger. See custom_sms_sender Below.
 * @property defineAuthChallenge Defines the authentication challenge.
 * @property kmsKeyId The Amazon Resource Name of Key Management Service Customer master keys. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to CustomEmailSender and CustomSMSSender.
 * @property postAuthentication Post-authentication AWS Lambda trigger.
 * @property postConfirmation Post-confirmation AWS Lambda trigger.
 * @property preAuthentication Pre-authentication AWS Lambda trigger.
 * @property preSignUp Pre-registration AWS Lambda trigger.
 * @property preTokenGeneration Allow to customize identity token claims before token generation.
 * @property userMigration User migration Lambda config type.
 * @property verifyAuthChallengeResponse Verifies the authentication challenge response.
 */
public data class UserPoolLambdaConfigArgs(
    public val createAuthChallenge: Output<String>? = null,
    public val customEmailSender: Output<UserPoolLambdaConfigCustomEmailSenderArgs>? = null,
    public val customMessage: Output<String>? = null,
    public val customSmsSender: Output<UserPoolLambdaConfigCustomSmsSenderArgs>? = null,
    public val defineAuthChallenge: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val postAuthentication: Output<String>? = null,
    public val postConfirmation: Output<String>? = null,
    public val preAuthentication: Output<String>? = null,
    public val preSignUp: Output<String>? = null,
    public val preTokenGeneration: Output<String>? = null,
    public val userMigration: Output<String>? = null,
    public val verifyAuthChallengeResponse: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigArgs =
        com.pulumi.aws.cognito.inputs.UserPoolLambdaConfigArgs.builder()
            .createAuthChallenge(createAuthChallenge?.applyValue({ args0 -> args0 }))
            .customEmailSender(customEmailSender?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customMessage(customMessage?.applyValue({ args0 -> args0 }))
            .customSmsSender(customSmsSender?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .defineAuthChallenge(defineAuthChallenge?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .postAuthentication(postAuthentication?.applyValue({ args0 -> args0 }))
            .postConfirmation(postConfirmation?.applyValue({ args0 -> args0 }))
            .preAuthentication(preAuthentication?.applyValue({ args0 -> args0 }))
            .preSignUp(preSignUp?.applyValue({ args0 -> args0 }))
            .preTokenGeneration(preTokenGeneration?.applyValue({ args0 -> args0 }))
            .userMigration(userMigration?.applyValue({ args0 -> args0 }))
            .verifyAuthChallengeResponse(verifyAuthChallengeResponse?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolLambdaConfigArgs].
 */
@PulumiTagMarker
public class UserPoolLambdaConfigArgsBuilder internal constructor() {
    private var createAuthChallenge: Output<String>? = null

    private var customEmailSender: Output<UserPoolLambdaConfigCustomEmailSenderArgs>? = null

    private var customMessage: Output<String>? = null

    private var customSmsSender: Output<UserPoolLambdaConfigCustomSmsSenderArgs>? = null

    private var defineAuthChallenge: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var postAuthentication: Output<String>? = null

    private var postConfirmation: Output<String>? = null

    private var preAuthentication: Output<String>? = null

    private var preSignUp: Output<String>? = null

    private var preTokenGeneration: Output<String>? = null

    private var userMigration: Output<String>? = null

    private var verifyAuthChallengeResponse: Output<String>? = null

    /**
     * @param value ARN of the lambda creating an authentication challenge.
     */
    @JvmName("pilomwwabhjieeji")
    public suspend fun createAuthChallenge(`value`: Output<String>) {
        this.createAuthChallenge = value
    }

    /**
     * @param value A custom email sender AWS Lambda trigger. See custom_email_sender Below.
     */
    @JvmName("vtewklpprfyypufv")
    public suspend fun customEmailSender(`value`: Output<UserPoolLambdaConfigCustomEmailSenderArgs>) {
        this.customEmailSender = value
    }

    /**
     * @param value Custom Message AWS Lambda trigger.
     */
    @JvmName("sdtnbreogbmwlvlc")
    public suspend fun customMessage(`value`: Output<String>) {
        this.customMessage = value
    }

    /**
     * @param value A custom SMS sender AWS Lambda trigger. See custom_sms_sender Below.
     */
    @JvmName("vxvwfhsqgxyerfgf")
    public suspend fun customSmsSender(`value`: Output<UserPoolLambdaConfigCustomSmsSenderArgs>) {
        this.customSmsSender = value
    }

    /**
     * @param value Defines the authentication challenge.
     */
    @JvmName("pfvsieoromalwvst")
    public suspend fun defineAuthChallenge(`value`: Output<String>) {
        this.defineAuthChallenge = value
    }

    /**
     * @param value The Amazon Resource Name of Key Management Service Customer master keys. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to CustomEmailSender and CustomSMSSender.
     */
    @JvmName("dnxhoibtfttsvyim")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Post-authentication AWS Lambda trigger.
     */
    @JvmName("kyaeotgpvwteuumx")
    public suspend fun postAuthentication(`value`: Output<String>) {
        this.postAuthentication = value
    }

    /**
     * @param value Post-confirmation AWS Lambda trigger.
     */
    @JvmName("hpofmrpktntnwnme")
    public suspend fun postConfirmation(`value`: Output<String>) {
        this.postConfirmation = value
    }

    /**
     * @param value Pre-authentication AWS Lambda trigger.
     */
    @JvmName("hhydrkofgveqdheh")
    public suspend fun preAuthentication(`value`: Output<String>) {
        this.preAuthentication = value
    }

    /**
     * @param value Pre-registration AWS Lambda trigger.
     */
    @JvmName("rwbdhcrtfwsbapvu")
    public suspend fun preSignUp(`value`: Output<String>) {
        this.preSignUp = value
    }

    /**
     * @param value Allow to customize identity token claims before token generation.
     */
    @JvmName("bchakicwbxcwuhiu")
    public suspend fun preTokenGeneration(`value`: Output<String>) {
        this.preTokenGeneration = value
    }

    /**
     * @param value User migration Lambda config type.
     */
    @JvmName("rbksyjubtuddnveq")
    public suspend fun userMigration(`value`: Output<String>) {
        this.userMigration = value
    }

    /**
     * @param value Verifies the authentication challenge response.
     */
    @JvmName("eyodiycuosvoblqt")
    public suspend fun verifyAuthChallengeResponse(`value`: Output<String>) {
        this.verifyAuthChallengeResponse = value
    }

    /**
     * @param value ARN of the lambda creating an authentication challenge.
     */
    @JvmName("uiyeebclpkxpaprb")
    public suspend fun createAuthChallenge(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createAuthChallenge = mapped
    }

    /**
     * @param value A custom email sender AWS Lambda trigger. See custom_email_sender Below.
     */
    @JvmName("lwfouwctksdgdhea")
    public suspend fun customEmailSender(`value`: UserPoolLambdaConfigCustomEmailSenderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customEmailSender = mapped
    }

    /**
     * @param argument A custom email sender AWS Lambda trigger. See custom_email_sender Below.
     */
    @JvmName("odafaeymyaktiiup")
    public suspend
    fun customEmailSender(argument: suspend UserPoolLambdaConfigCustomEmailSenderArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolLambdaConfigCustomEmailSenderArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customEmailSender = mapped
    }

    /**
     * @param value Custom Message AWS Lambda trigger.
     */
    @JvmName("ubqesmexulwtokkx")
    public suspend fun customMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customMessage = mapped
    }

    /**
     * @param value A custom SMS sender AWS Lambda trigger. See custom_sms_sender Below.
     */
    @JvmName("ghtgrmhmowhkvsas")
    public suspend fun customSmsSender(`value`: UserPoolLambdaConfigCustomSmsSenderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSmsSender = mapped
    }

    /**
     * @param argument A custom SMS sender AWS Lambda trigger. See custom_sms_sender Below.
     */
    @JvmName("afdkxhwxpsdewkot")
    public suspend
    fun customSmsSender(argument: suspend UserPoolLambdaConfigCustomSmsSenderArgsBuilder.() -> Unit) {
        val toBeMapped = UserPoolLambdaConfigCustomSmsSenderArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customSmsSender = mapped
    }

    /**
     * @param value Defines the authentication challenge.
     */
    @JvmName("beudiqwrdcjnkbhl")
    public suspend fun defineAuthChallenge(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defineAuthChallenge = mapped
    }

    /**
     * @param value The Amazon Resource Name of Key Management Service Customer master keys. Amazon Cognito uses the key to encrypt codes and temporary passwords sent to CustomEmailSender and CustomSMSSender.
     */
    @JvmName("puwxvdbnnlikupgt")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Post-authentication AWS Lambda trigger.
     */
    @JvmName("jvjyfbrneqxsqagb")
    public suspend fun postAuthentication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postAuthentication = mapped
    }

    /**
     * @param value Post-confirmation AWS Lambda trigger.
     */
    @JvmName("hwksgnpnciqybept")
    public suspend fun postConfirmation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postConfirmation = mapped
    }

    /**
     * @param value Pre-authentication AWS Lambda trigger.
     */
    @JvmName("leylivafqfdcuglx")
    public suspend fun preAuthentication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preAuthentication = mapped
    }

    /**
     * @param value Pre-registration AWS Lambda trigger.
     */
    @JvmName("suldmpaqshdyafjx")
    public suspend fun preSignUp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preSignUp = mapped
    }

    /**
     * @param value Allow to customize identity token claims before token generation.
     */
    @JvmName("dgwylaaefyqkwpgw")
    public suspend fun preTokenGeneration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preTokenGeneration = mapped
    }

    /**
     * @param value User migration Lambda config type.
     */
    @JvmName("upucxoerhjtaulei")
    public suspend fun userMigration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userMigration = mapped
    }

    /**
     * @param value Verifies the authentication challenge response.
     */
    @JvmName("gtynpvjljoworkvm")
    public suspend fun verifyAuthChallengeResponse(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.verifyAuthChallengeResponse = mapped
    }

    internal fun build(): UserPoolLambdaConfigArgs = UserPoolLambdaConfigArgs(
        createAuthChallenge = createAuthChallenge,
        customEmailSender = customEmailSender,
        customMessage = customMessage,
        customSmsSender = customSmsSender,
        defineAuthChallenge = defineAuthChallenge,
        kmsKeyId = kmsKeyId,
        postAuthentication = postAuthentication,
        postConfirmation = postConfirmation,
        preAuthentication = preAuthentication,
        preSignUp = preSignUp,
        preTokenGeneration = preTokenGeneration,
        userMigration = userMigration,
        verifyAuthChallengeResponse = verifyAuthChallengeResponse,
    )
}
