@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolPasswordPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property minimumLength Minimum length of the password policy that you have set.
 * @property requireLowercase Whether you have required users to use at least one lowercase letter in their password.
 * @property requireNumbers Whether you have required users to use at least one number in their password.
 * @property requireSymbols Whether you have required users to use at least one symbol in their password.
 * @property requireUppercase Whether you have required users to use at least one uppercase letter in their password.
 * @property temporaryPasswordValidityDays In the password policy you have set, refers to the number of days a temporary password is valid. If the user does not sign-in during this time, their password will need to be reset by an administrator.
 */
public data class UserPoolPasswordPolicyArgs(
    public val minimumLength: Output<Int>? = null,
    public val requireLowercase: Output<Boolean>? = null,
    public val requireNumbers: Output<Boolean>? = null,
    public val requireSymbols: Output<Boolean>? = null,
    public val requireUppercase: Output<Boolean>? = null,
    public val temporaryPasswordValidityDays: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolPasswordPolicyArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolPasswordPolicyArgs =
        com.pulumi.aws.cognito.inputs.UserPoolPasswordPolicyArgs.builder()
            .minimumLength(minimumLength?.applyValue({ args0 -> args0 }))
            .requireLowercase(requireLowercase?.applyValue({ args0 -> args0 }))
            .requireNumbers(requireNumbers?.applyValue({ args0 -> args0 }))
            .requireSymbols(requireSymbols?.applyValue({ args0 -> args0 }))
            .requireUppercase(requireUppercase?.applyValue({ args0 -> args0 }))
            .temporaryPasswordValidityDays(
                temporaryPasswordValidityDays?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [UserPoolPasswordPolicyArgs].
 */
@PulumiTagMarker
public class UserPoolPasswordPolicyArgsBuilder internal constructor() {
    private var minimumLength: Output<Int>? = null

    private var requireLowercase: Output<Boolean>? = null

    private var requireNumbers: Output<Boolean>? = null

    private var requireSymbols: Output<Boolean>? = null

    private var requireUppercase: Output<Boolean>? = null

    private var temporaryPasswordValidityDays: Output<Int>? = null

    /**
     * @param value Minimum length of the password policy that you have set.
     */
    @JvmName("dkfffgvfbllubfhq")
    public suspend fun minimumLength(`value`: Output<Int>) {
        this.minimumLength = value
    }

    /**
     * @param value Whether you have required users to use at least one lowercase letter in their password.
     */
    @JvmName("ftqcaexlgokvcekv")
    public suspend fun requireLowercase(`value`: Output<Boolean>) {
        this.requireLowercase = value
    }

    /**
     * @param value Whether you have required users to use at least one number in their password.
     */
    @JvmName("kkhjibpogqbwmsxi")
    public suspend fun requireNumbers(`value`: Output<Boolean>) {
        this.requireNumbers = value
    }

    /**
     * @param value Whether you have required users to use at least one symbol in their password.
     */
    @JvmName("yqyajhsqryfybamk")
    public suspend fun requireSymbols(`value`: Output<Boolean>) {
        this.requireSymbols = value
    }

    /**
     * @param value Whether you have required users to use at least one uppercase letter in their password.
     */
    @JvmName("oyjjdbvkkosutqnt")
    public suspend fun requireUppercase(`value`: Output<Boolean>) {
        this.requireUppercase = value
    }

    /**
     * @param value In the password policy you have set, refers to the number of days a temporary password is valid. If the user does not sign-in during this time, their password will need to be reset by an administrator.
     */
    @JvmName("nmjjeghloynkwwny")
    public suspend fun temporaryPasswordValidityDays(`value`: Output<Int>) {
        this.temporaryPasswordValidityDays = value
    }

    /**
     * @param value Minimum length of the password policy that you have set.
     */
    @JvmName("mchtxuppdjeaakuh")
    public suspend fun minimumLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumLength = mapped
    }

    /**
     * @param value Whether you have required users to use at least one lowercase letter in their password.
     */
    @JvmName("ebcwqcsmfxordgkk")
    public suspend fun requireLowercase(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireLowercase = mapped
    }

    /**
     * @param value Whether you have required users to use at least one number in their password.
     */
    @JvmName("uoabxloqqeigjllm")
    public suspend fun requireNumbers(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireNumbers = mapped
    }

    /**
     * @param value Whether you have required users to use at least one symbol in their password.
     */
    @JvmName("yyjcxtwmqyfapiyq")
    public suspend fun requireSymbols(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireSymbols = mapped
    }

    /**
     * @param value Whether you have required users to use at least one uppercase letter in their password.
     */
    @JvmName("agqgffepgjpsqoim")
    public suspend fun requireUppercase(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireUppercase = mapped
    }

    /**
     * @param value In the password policy you have set, refers to the number of days a temporary password is valid. If the user does not sign-in during this time, their password will need to be reset by an administrator.
     */
    @JvmName("ihytxuvirwnhmxet")
    public suspend fun temporaryPasswordValidityDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.temporaryPasswordValidityDays = mapped
    }

    internal fun build(): UserPoolPasswordPolicyArgs = UserPoolPasswordPolicyArgs(
        minimumLength = minimumLength,
        requireLowercase = requireLowercase,
        requireNumbers = requireNumbers,
        requireSymbols = requireSymbols,
        requireUppercase = requireUppercase,
        temporaryPasswordValidityDays = temporaryPasswordValidityDays,
    )
}
