@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolSchemaNumberAttributeConstraintsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxValue Maximum value of an attribute that is of the number data type.
 * @property minValue Minimum value of an attribute that is of the number data type.
 */
public data class UserPoolSchemaNumberAttributeConstraintsArgs(
    public val maxValue: Output<String>? = null,
    public val minValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolSchemaNumberAttributeConstraintsArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolSchemaNumberAttributeConstraintsArgs =
        com.pulumi.aws.cognito.inputs.UserPoolSchemaNumberAttributeConstraintsArgs.builder()
            .maxValue(maxValue?.applyValue({ args0 -> args0 }))
            .minValue(minValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolSchemaNumberAttributeConstraintsArgs].
 */
@PulumiTagMarker
public class UserPoolSchemaNumberAttributeConstraintsArgsBuilder internal constructor() {
    private var maxValue: Output<String>? = null

    private var minValue: Output<String>? = null

    /**
     * @param value Maximum value of an attribute that is of the number data type.
     */
    @JvmName("eohvvqcswnxwqktb")
    public suspend fun maxValue(`value`: Output<String>) {
        this.maxValue = value
    }

    /**
     * @param value Minimum value of an attribute that is of the number data type.
     */
    @JvmName("vvwgomwoudtddhkq")
    public suspend fun minValue(`value`: Output<String>) {
        this.minValue = value
    }

    /**
     * @param value Maximum value of an attribute that is of the number data type.
     */
    @JvmName("isranwvovfplblmc")
    public suspend fun maxValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxValue = mapped
    }

    /**
     * @param value Minimum value of an attribute that is of the number data type.
     */
    @JvmName("usmtgwlalwhdeucu")
    public suspend fun minValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minValue = mapped
    }

    internal fun build(): UserPoolSchemaNumberAttributeConstraintsArgs =
        UserPoolSchemaNumberAttributeConstraintsArgs(
            maxValue = maxValue,
            minValue = minValue,
        )
}
