@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolSmsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property externalId External ID used in IAM role trust relationships. For more information about using external IDs, see [How to Use an External ID When Granting Access to Your AWS Resources to a Third Party](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html).
 * @property snsCallerArn ARN of the Amazon SNS caller. This is usually the IAM role that you've given Cognito permission to assume.
 * @property snsRegion The AWS Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported Legacy Amazon SNS alternate Region. Amazon Cognito resources in the Asia Pacific (Seoul) AWS Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see [SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html).
 */
public data class UserPoolSmsConfigurationArgs(
    public val externalId: Output<String>,
    public val snsCallerArn: Output<String>,
    public val snsRegion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolSmsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolSmsConfigurationArgs =
        com.pulumi.aws.cognito.inputs.UserPoolSmsConfigurationArgs.builder()
            .externalId(externalId.applyValue({ args0 -> args0 }))
            .snsCallerArn(snsCallerArn.applyValue({ args0 -> args0 }))
            .snsRegion(snsRegion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolSmsConfigurationArgs].
 */
@PulumiTagMarker
public class UserPoolSmsConfigurationArgsBuilder internal constructor() {
    private var externalId: Output<String>? = null

    private var snsCallerArn: Output<String>? = null

    private var snsRegion: Output<String>? = null

    /**
     * @param value External ID used in IAM role trust relationships. For more information about using external IDs, see [How to Use an External ID When Granting Access to Your AWS Resources to a Third Party](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html).
     */
    @JvmName("khktckrmqxnidsxa")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value ARN of the Amazon SNS caller. This is usually the IAM role that you've given Cognito permission to assume.
     */
    @JvmName("qgauptotnujkhvwp")
    public suspend fun snsCallerArn(`value`: Output<String>) {
        this.snsCallerArn = value
    }

    /**
     * @param value The AWS Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported Legacy Amazon SNS alternate Region. Amazon Cognito resources in the Asia Pacific (Seoul) AWS Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see [SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html).
     */
    @JvmName("afxnvtmlulemdrrm")
    public suspend fun snsRegion(`value`: Output<String>) {
        this.snsRegion = value
    }

    /**
     * @param value External ID used in IAM role trust relationships. For more information about using external IDs, see [How to Use an External ID When Granting Access to Your AWS Resources to a Third Party](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html).
     */
    @JvmName("oyoufjexhbchqrke")
    public suspend fun externalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value ARN of the Amazon SNS caller. This is usually the IAM role that you've given Cognito permission to assume.
     */
    @JvmName("xtorlpeytdtjlyyc")
    public suspend fun snsCallerArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snsCallerArn = mapped
    }

    /**
     * @param value The AWS Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported Legacy Amazon SNS alternate Region. Amazon Cognito resources in the Asia Pacific (Seoul) AWS Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see [SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html).
     */
    @JvmName("jlwlquatkajhaiie")
    public suspend fun snsRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsRegion = mapped
    }

    internal fun build(): UserPoolSmsConfigurationArgs = UserPoolSmsConfigurationArgs(
        externalId = externalId ?: throw PulumiNullFieldException("externalId"),
        snsCallerArn = snsCallerArn ?: throw PulumiNullFieldException("snsCallerArn"),
        snsRegion = snsRegion,
    )
}
