@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolUserPoolAddOnsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property advancedSecurityMode Mode for advanced security, must be one of `OFF`, `AUDIT` or `ENFORCED`.
 */
public data class UserPoolUserPoolAddOnsArgs(
    public val advancedSecurityMode: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolUserPoolAddOnsArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolUserPoolAddOnsArgs =
        com.pulumi.aws.cognito.inputs.UserPoolUserPoolAddOnsArgs.builder()
            .advancedSecurityMode(advancedSecurityMode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolUserPoolAddOnsArgs].
 */
@PulumiTagMarker
public class UserPoolUserPoolAddOnsArgsBuilder internal constructor() {
    private var advancedSecurityMode: Output<String>? = null

    /**
     * @param value Mode for advanced security, must be one of `OFF`, `AUDIT` or `ENFORCED`.
     */
    @JvmName("blhxbuxewfcuvqiv")
    public suspend fun advancedSecurityMode(`value`: Output<String>) {
        this.advancedSecurityMode = value
    }

    /**
     * @param value Mode for advanced security, must be one of `OFF`, `AUDIT` or `ENFORCED`.
     */
    @JvmName("mepaggwuaglxkebt")
    public suspend fun advancedSecurityMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advancedSecurityMode = mapped
    }

    internal fun build(): UserPoolUserPoolAddOnsArgs = UserPoolUserPoolAddOnsArgs(
        advancedSecurityMode = advancedSecurityMode ?: throw
            PulumiNullFieldException("advancedSecurityMode"),
    )
}
