@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.inputs

import com.pulumi.aws.cognito.inputs.UserPoolVerificationMessageTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultEmailOption Default email option. Must be either `CONFIRM_WITH_CODE` or `CONFIRM_WITH_LINK`. Defaults to `CONFIRM_WITH_CODE`.
 * @property emailMessage Email message template. Must contain the `{####}` placeholder. Conflicts with `email_verification_message` argument.
 * @property emailMessageByLink Email message template for sending a confirmation link to the user, it must contain the `{##Click Here##}` placeholder.
 * @property emailSubject Subject line for the email message template. Conflicts with `email_verification_subject` argument.
 * @property emailSubjectByLink Subject line for the email message template for sending a confirmation link to the user.
 * @property smsMessage SMS message template. Must contain the `{####}` placeholder. Conflicts with `sms_verification_message` argument.
 */
public data class UserPoolVerificationMessageTemplateArgs(
    public val defaultEmailOption: Output<String>? = null,
    public val emailMessage: Output<String>? = null,
    public val emailMessageByLink: Output<String>? = null,
    public val emailSubject: Output<String>? = null,
    public val emailSubjectByLink: Output<String>? = null,
    public val smsMessage: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.cognito.inputs.UserPoolVerificationMessageTemplateArgs> {
    override fun toJava(): com.pulumi.aws.cognito.inputs.UserPoolVerificationMessageTemplateArgs =
        com.pulumi.aws.cognito.inputs.UserPoolVerificationMessageTemplateArgs.builder()
            .defaultEmailOption(defaultEmailOption?.applyValue({ args0 -> args0 }))
            .emailMessage(emailMessage?.applyValue({ args0 -> args0 }))
            .emailMessageByLink(emailMessageByLink?.applyValue({ args0 -> args0 }))
            .emailSubject(emailSubject?.applyValue({ args0 -> args0 }))
            .emailSubjectByLink(emailSubjectByLink?.applyValue({ args0 -> args0 }))
            .smsMessage(smsMessage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserPoolVerificationMessageTemplateArgs].
 */
@PulumiTagMarker
public class UserPoolVerificationMessageTemplateArgsBuilder internal constructor() {
    private var defaultEmailOption: Output<String>? = null

    private var emailMessage: Output<String>? = null

    private var emailMessageByLink: Output<String>? = null

    private var emailSubject: Output<String>? = null

    private var emailSubjectByLink: Output<String>? = null

    private var smsMessage: Output<String>? = null

    /**
     * @param value Default email option. Must be either `CONFIRM_WITH_CODE` or `CONFIRM_WITH_LINK`. Defaults to `CONFIRM_WITH_CODE`.
     */
    @JvmName("qojvcyxgbdxygivr")
    public suspend fun defaultEmailOption(`value`: Output<String>) {
        this.defaultEmailOption = value
    }

    /**
     * @param value Email message template. Must contain the `{####}` placeholder. Conflicts with `email_verification_message` argument.
     */
    @JvmName("rrbwnnclvsvserfh")
    public suspend fun emailMessage(`value`: Output<String>) {
        this.emailMessage = value
    }

    /**
     * @param value Email message template for sending a confirmation link to the user, it must contain the `{##Click Here##}` placeholder.
     */
    @JvmName("junhnkwwaqeoceof")
    public suspend fun emailMessageByLink(`value`: Output<String>) {
        this.emailMessageByLink = value
    }

    /**
     * @param value Subject line for the email message template. Conflicts with `email_verification_subject` argument.
     */
    @JvmName("nfjynnqhbcbhjxxm")
    public suspend fun emailSubject(`value`: Output<String>) {
        this.emailSubject = value
    }

    /**
     * @param value Subject line for the email message template for sending a confirmation link to the user.
     */
    @JvmName("quxtlobtshxwhpje")
    public suspend fun emailSubjectByLink(`value`: Output<String>) {
        this.emailSubjectByLink = value
    }

    /**
     * @param value SMS message template. Must contain the `{####}` placeholder. Conflicts with `sms_verification_message` argument.
     */
    @JvmName("shgbudfipvupribq")
    public suspend fun smsMessage(`value`: Output<String>) {
        this.smsMessage = value
    }

    /**
     * @param value Default email option. Must be either `CONFIRM_WITH_CODE` or `CONFIRM_WITH_LINK`. Defaults to `CONFIRM_WITH_CODE`.
     */
    @JvmName("xelwfdpetlyqvqrs")
    public suspend fun defaultEmailOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultEmailOption = mapped
    }

    /**
     * @param value Email message template. Must contain the `{####}` placeholder. Conflicts with `email_verification_message` argument.
     */
    @JvmName("twxloyyvwesflrpo")
    public suspend fun emailMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailMessage = mapped
    }

    /**
     * @param value Email message template for sending a confirmation link to the user, it must contain the `{##Click Here##}` placeholder.
     */
    @JvmName("jyjemqhpbacxbggw")
    public suspend fun emailMessageByLink(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailMessageByLink = mapped
    }

    /**
     * @param value Subject line for the email message template. Conflicts with `email_verification_subject` argument.
     */
    @JvmName("hufyqrlgijknhnxd")
    public suspend fun emailSubject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailSubject = mapped
    }

    /**
     * @param value Subject line for the email message template for sending a confirmation link to the user.
     */
    @JvmName("ueapxwkpfobanvnh")
    public suspend fun emailSubjectByLink(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailSubjectByLink = mapped
    }

    /**
     * @param value SMS message template. Must contain the `{####}` placeholder. Conflicts with `sms_verification_message` argument.
     */
    @JvmName("yrakdxtwogesecgb")
    public suspend fun smsMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smsMessage = mapped
    }

    internal fun build(): UserPoolVerificationMessageTemplateArgs =
        UserPoolVerificationMessageTemplateArgs(
            defaultEmailOption = defaultEmailOption,
            emailMessage = emailMessage,
            emailMessageByLink = emailMessageByLink,
            emailSubject = emailSubject,
            emailSubjectByLink = emailSubjectByLink,
            smsMessage = smsMessage,
        )
}
