@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessToken (Optional) Time unit in for the value in `access_token_validity`, defaults to `hours`.
 * @property idToken (Optional) Time unit in for the value in `id_token_validity`, defaults to `hours`.
 * @property refreshToken (Optional) Time unit in for the value in `refresh_token_validity`, defaults to `days`.
 */
public data class GetUserPoolClientTokenValidityUnit(
    public val accessToken: String,
    public val idToken: String,
    public val refreshToken: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolClientTokenValidityUnit):
            GetUserPoolClientTokenValidityUnit = GetUserPoolClientTokenValidityUnit(
            accessToken = javaType.accessToken(),
            idToken = javaType.idToken(),
            refreshToken = javaType.refreshToken(),
        )
    }
}
