@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUserPoolClients.
 * @property clientIds List of Cognito user pool client IDs.
 * @property clientNames List of Cognito user pool client names.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property userPoolId
 */
public data class GetUserPoolClientsResult(
    public val clientIds: List<String>,
    public val clientNames: List<String>,
    public val id: String,
    public val userPoolId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolClientsResult):
            GetUserPoolClientsResult = GetUserPoolClientsResult(
            clientIds = javaType.clientIds().map({ args0 -> args0 }),
            clientNames = javaType.clientNames().map({ args0 -> args0 }),
            id = javaType.id(),
            userPoolId = javaType.userPoolId(),
        )
    }
}
