@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getUserPoolSigningCertificate.
 * @property certificate Certificate string
 * @property id The provider-assigned unique ID for this managed resource.
 * @property userPoolId
 */
public data class GetUserPoolSigningCertificateResult(
    public val certificate: String,
    public val id: String,
    public val userPoolId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolSigningCertificateResult):
            GetUserPoolSigningCertificateResult = GetUserPoolSigningCertificateResult(
            certificate = javaType.certificate(),
            id = javaType.id(),
            userPoolId = javaType.userPoolId(),
        )
    }
}
