@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getUserPools.
 * @property arns Set of cognito user pool Amazon Resource Names (ARNs).
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Set of cognito user pool ids.
 * @property name
 */
public data class GetUserPoolsResult(
    public val arns: List<String>,
    public val id: String,
    public val ids: List<String>,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.GetUserPoolsResult):
            GetUserPoolsResult = GetUserPoolsResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            name = javaType.name(),
        )
    }
}
