@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientId The client ID for the Amazon Cognito Identity User Pool.
 * @property providerName The provider name for an Amazon Cognito Identity User Pool.
 * @property serverSideTokenCheck Whether server-side token validation is enabled for the identity provider’s token or not.
 */
public data class IdentityPoolCognitoIdentityProvider(
    public val clientId: String? = null,
    public val providerName: String? = null,
    public val serverSideTokenCheck: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.IdentityPoolCognitoIdentityProvider):
            IdentityPoolCognitoIdentityProvider = IdentityPoolCognitoIdentityProvider(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            providerName = javaType.providerName().map({ args0 -> args0 }).orElse(null),
            serverSideTokenCheck = javaType.serverSideTokenCheck().map({ args0 -> args0 }).orElse(null),
        )
    }
}
