@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ambiguousRoleResolution Specifies the action to be taken if either no rules match the claim value for the Rules type, or there is no cognito:preferred_role claim and there are multiple cognito:roles matches for the Token type. `Required` if you specify Token or Rules as the Type.
 * @property identityProvider A string identifying the identity provider, for example, "graph.facebook.com" or "cognito-idp.us-east-1.amazonaws.com/us-east-1_abcdefghi:app_client_id". Depends on `cognito_identity_providers` set on `aws.cognito.IdentityPool` resource or a `aws.cognito.IdentityProvider` resource.
 * @property mappingRules The Rules Configuration to be used for mapping users to roles. You can specify up to 25 rules per identity provider. Rules are evaluated in order. The first one to match specifies the role.
 * @property type The role mapping type.
 */
public data class IdentityPoolRoleAttachmentRoleMapping(
    public val ambiguousRoleResolution: String? = null,
    public val identityProvider: String,
    public val mappingRules: List<IdentityPoolRoleAttachmentRoleMappingMappingRule>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.IdentityPoolRoleAttachmentRoleMapping):
            IdentityPoolRoleAttachmentRoleMapping = IdentityPoolRoleAttachmentRoleMapping(
            ambiguousRoleResolution = javaType.ambiguousRoleResolution().map({ args0 -> args0 }).orElse(null),
            identityProvider = javaType.identityProvider(),
            mappingRules = javaType.mappingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.IdentityPoolRoleAttachmentRoleMappingMappingRule.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
