@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property claim The claim name that must be present in the token, for example, "isAdmin" or "paid".
 * @property matchType The match condition that specifies how closely the claim value in the IdP token must match Value.
 * @property roleArn The role ARN.
 * @property value A brief string that the claim must match, for example, "paid" or "yes".
 */
public data class IdentityPoolRoleAttachmentRoleMappingMappingRule(
    public val claim: String,
    public val matchType: String,
    public val roleArn: String,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.IdentityPoolRoleAttachmentRoleMappingMappingRule):
            IdentityPoolRoleAttachmentRoleMappingMappingRule =
            IdentityPoolRoleAttachmentRoleMappingMappingRule(
                claim = javaType.claim(),
                matchType = javaType.matchType(),
                roleArn = javaType.roleArn(),
                `value` = javaType.`value`(),
            )
    }
}
