@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property blockEmail Email template used when a detected risk event is blocked. See notify email type below.
 * @property from The email address that is sending the email. The address must be either individually verified with Amazon Simple Email Service, or from a domain that has been verified with Amazon SES.
 * @property mfaEmail The multi-factor authentication (MFA) email template used when MFA is challenged as part of a detected risk. See notify email type below.
 * @property noActionEmail The email template used when a detected risk event is allowed. See notify email type below.
 * @property replyTo The destination to which the receiver of an email should reply to.
 * @property sourceArn The Amazon Resource Name (ARN) of the identity that is associated with the sending authorization policy. This identity permits Amazon Cognito to send for the email address specified in the From parameter.
 */
public data class RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfiguration(
    public val blockEmail:
    RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmail? = null,
    public val from: String? = null,
    public val mfaEmail: RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationMfaEmail? =
        null,
    public val noActionEmail:
    RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationNoActionEmail? = null,
    public val replyTo: String? = null,
    public val sourceArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfiguration):
            RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfiguration =
            RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfiguration(
                blockEmail = javaType.blockEmail().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationBlockEmail.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                from = javaType.from().map({ args0 -> args0 }).orElse(null),
                mfaEmail = javaType.mfaEmail().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationMfaEmail.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                noActionEmail = javaType.noActionEmail().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.cognito.kotlin.outputs.RiskConfigurationAccountTakeoverRiskConfigurationNotifyConfigurationNoActionEmail.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                replyTo = javaType.replyTo().map({ args0 -> args0 }).orElse(null),
                sourceArn = javaType.sourceArn(),
            )
    }
}
