@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property allowAdminCreateUserOnly Set to True if only the administrator is allowed to create user profiles. Set to False if users can sign themselves up via an app.
 * @property inviteMessageTemplate Invite message template structure. Detailed below.
 */
public data class UserPoolAdminCreateUserConfig(
    public val allowAdminCreateUserOnly: Boolean? = null,
    public val inviteMessageTemplate: UserPoolAdminCreateUserConfigInviteMessageTemplate? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolAdminCreateUserConfig):
            UserPoolAdminCreateUserConfig = UserPoolAdminCreateUserConfig(
            allowAdminCreateUserOnly = javaType.allowAdminCreateUserOnly().map({ args0 -> args0 }).orElse(null),
            inviteMessageTemplate = javaType.inviteMessageTemplate().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cognito.kotlin.outputs.UserPoolAdminCreateUserConfigInviteMessageTemplate.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
