@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property configurationSet Email configuration set name from SES.
 * @property emailSendingAccount Email delivery method to use. `COGNITO_DEFAULT` for the default email functionality built into Cognito or `DEVELOPER` to use your Amazon SES configuration. Required to be `DEVELOPER` if `from_email_address` is set.
 * @property fromEmailAddress Sender’s email address or sender’s display name with their email address (e.g., `john@example.com`, `John Smith <john@example.com>` or `\"John Smith Ph.D.\" <john@example.com>`). Escaped double quotes are required around display names that contain certain characters as specified in [RFC 5322](https://tools.ietf.org/html/rfc5322).
 * @property replyToEmailAddress REPLY-TO email address.
 * @property sourceArn ARN of the SES verified email identity to use. Required if `email_sending_account` is set to `DEVELOPER`.
 */
public data class UserPoolEmailConfiguration(
    public val configurationSet: String? = null,
    public val emailSendingAccount: String? = null,
    public val fromEmailAddress: String? = null,
    public val replyToEmailAddress: String? = null,
    public val sourceArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolEmailConfiguration):
            UserPoolEmailConfiguration = UserPoolEmailConfiguration(
            configurationSet = javaType.configurationSet().map({ args0 -> args0 }).orElse(null),
            emailSendingAccount = javaType.emailSendingAccount().map({ args0 -> args0 }).orElse(null),
            fromEmailAddress = javaType.fromEmailAddress().map({ args0 -> args0 }).orElse(null),
            replyToEmailAddress = javaType.replyToEmailAddress().map({ args0 -> args0 }).orElse(null),
            sourceArn = javaType.sourceArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
