@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property externalId External ID used in IAM role trust relationships. For more information about using external IDs, see [How to Use an External ID When Granting Access to Your AWS Resources to a Third Party](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html).
 * @property snsCallerArn ARN of the Amazon SNS caller. This is usually the IAM role that you've given Cognito permission to assume.
 * @property snsRegion The AWS Region to use with Amazon SNS integration. You can choose the same Region as your user pool, or a supported Legacy Amazon SNS alternate Region. Amazon Cognito resources in the Asia Pacific (Seoul) AWS Region must use your Amazon SNS configuration in the Asia Pacific (Tokyo) Region. For more information, see [SMS message settings for Amazon Cognito user pools](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html).
 */
public data class UserPoolSmsConfiguration(
    public val externalId: String,
    public val snsCallerArn: String,
    public val snsRegion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolSmsConfiguration):
            UserPoolSmsConfiguration = UserPoolSmsConfiguration(
            externalId = javaType.externalId(),
            snsCallerArn = javaType.snsCallerArn(),
            snsRegion = javaType.snsRegion().map({ args0 -> args0 }).orElse(null),
        )
    }
}
