@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enabled Boolean whether to enable software token Multi-Factor (MFA) tokens, such as Time-based One-Time Password (TOTP). To disable software token MFA When `sms_configuration` is not present, the `mfa_configuration` argument must be set to `OFF` and the `software_token_mfa_configuration` configuration block must be fully removed.
 */
public data class UserPoolSoftwareTokenMfaConfiguration(
    public val enabled: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolSoftwareTokenMfaConfiguration):
            UserPoolSoftwareTokenMfaConfiguration = UserPoolSoftwareTokenMfaConfiguration(
            enabled = javaType.enabled(),
        )
    }
}
