@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cognito.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property caseSensitive Whether username case sensitivity will be applied for all users in the user pool through Cognito APIs.
 */
public data class UserPoolUsernameConfiguration(
    public val caseSensitive: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cognito.outputs.UserPoolUsernameConfiguration):
            UserPoolUsernameConfiguration = UserPoolUsernameConfiguration(
            caseSensitive = javaType.caseSensitive(),
        )
    }
}
