@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin

import com.pulumi.aws.comprehend.kotlin.outputs.EntityRecognizerInputDataConfig
import com.pulumi.aws.comprehend.kotlin.outputs.EntityRecognizerVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.comprehend.kotlin.outputs.EntityRecognizerInputDataConfig.Companion.toKotlin as entityRecognizerInputDataConfigToKotlin
import com.pulumi.aws.comprehend.kotlin.outputs.EntityRecognizerVpcConfig.Companion.toKotlin as entityRecognizerVpcConfigToKotlin

/**
 * Builder for [EntityRecognizer].
 */
@PulumiTagMarker
public class EntityRecognizerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EntityRecognizerArgs = EntityRecognizerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EntityRecognizerArgsBuilder.() -> Unit) {
        val builder = EntityRecognizerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): EntityRecognizer {
        val builtJavaResource = com.pulumi.aws.comprehend.EntityRecognizer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EntityRecognizer(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Comprehend Entity Recognizer.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.comprehend.EntityRecognizer;
 * import com.pulumi.aws.comprehend.EntityRecognizerArgs;
 * import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigArgs;
 * import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigDocumentsArgs;
 * import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigEntityListArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var documents = new BucketObjectv2("documents");
 *         var entities = new BucketObjectv2("entities");
 *         var example = new EntityRecognizer("example", EntityRecognizerArgs.builder()
 *             .dataAccessRoleArn(aws_iam_role.example().arn())
 *             .languageCode("en")
 *             .inputDataConfig(EntityRecognizerInputDataConfigArgs.builder()
 *                 .entityTypes(
 *                     EntityRecognizerInputDataConfigEntityTypeArgs.builder()
 *                         .type("ENTITY_1")
 *                         .build(),
 *                     EntityRecognizerInputDataConfigEntityTypeArgs.builder()
 *                         .type("ENTITY_2")
 *                         .build())
 *                 .documents(EntityRecognizerInputDataConfigDocumentsArgs.builder()
 *                     .s3Uri(documents.id().applyValue(id -> String.format("s3://%s/%s", aws_s3_bucket.documents().bucket(),id)))
 *                     .build())
 *                 .entityList(EntityRecognizerInputDataConfigEntityListArgs.builder()
 *                     .s3Uri(entities.id().applyValue(id -> String.format("s3://%s/%s", aws_s3_bucket.entities().bucket(),id)))
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_iam_role_policy.example())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Comprehend Entity Recognizer using the ARN. For example:
 * ```sh
 *  $ pulumi import aws:comprehend/entityRecognizer:EntityRecognizer example arn:aws:comprehend:us-west-2:123456789012:entity-recognizer/example
 * ```
 *
 */
public class EntityRecognizer internal constructor(
    override val javaResource: com.pulumi.aws.comprehend.EntityRecognizer,
) : KotlinCustomResource(javaResource, EntityRecognizerMapper) {
    /**
     * ARN of the Entity Recognizer version.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ARN for an IAM Role which allows Comprehend to read the training and testing data.
     */
    public val dataAccessRoleArn: Output<String>
        get() = javaResource.dataAccessRoleArn().applyValue({ args0 -> args0 })

    /**
     * Configuration for the training and testing data.
     * See the `input_data_config` Configuration Block section below.
     */
    public val inputDataConfig: Output<EntityRecognizerInputDataConfig>
        get() = javaResource.inputDataConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                entityRecognizerInputDataConfigToKotlin(args0)
            })
        })

    /**
     * Two-letter language code for the language.
     * One of `en`, `es`, `fr`, `it`, `de`, or `pt`.
     */
    public val languageCode: Output<String>
        get() = javaResource.languageCode().applyValue({ args0 -> args0 })

    /**
     * The ID or ARN of a KMS Key used to encrypt trained Entity Recognizers.
     */
    public val modelKmsKeyId: Output<String>?
        get() = javaResource.modelKmsKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name for the Entity Recognizer.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` Configuration Block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Name for the version of the Entity Recognizer.
     * Each version must have a unique name within the Entity Recognizer.
     * If omitted, the provider will assign a random, unique version name.
     * If explicitly set to `""`, no version name will be set.
     * Has a maximum length of 63 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name_prefix`.
     */
    public val versionName: Output<String>
        get() = javaResource.versionName().applyValue({ args0 -> args0 })

    /**
     * Creates a unique version name beginning with the specified prefix.
     * Has a maximum length of 37 characters.
     * Can contain upper- and lower-case letters, numbers, and hypen (`-`).
     * Conflicts with `version_name`.
     */
    public val versionNamePrefix: Output<String>
        get() = javaResource.versionNamePrefix().applyValue({ args0 -> args0 })

    /**
     * ID or ARN of a KMS Key used to encrypt storage volumes during job processing.
     */
    public val volumeKmsKeyId: Output<String>?
        get() = javaResource.volumeKmsKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration parameters for VPC to contain Entity Recognizer resources.
     * See the `vpc_config` Configuration Block section below.
     */
    public val vpcConfig: Output<EntityRecognizerVpcConfig>?
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    entityRecognizerVpcConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object EntityRecognizerMapper : ResourceMapper<EntityRecognizer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.comprehend.EntityRecognizer::class == javaResource::class

    override fun map(javaResource: Resource): EntityRecognizer = EntityRecognizer(
        javaResource as
            com.pulumi.aws.comprehend.EntityRecognizer,
    )
}

/**
 * @see [EntityRecognizer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EntityRecognizer].
 */
public suspend fun entityRecognizer(
    name: String,
    block: suspend EntityRecognizerResourceBuilder.() -> Unit,
): EntityRecognizer {
    val builder = EntityRecognizerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EntityRecognizer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun entityRecognizer(name: String): EntityRecognizer {
    val builder = EntityRecognizerResourceBuilder()
    builder.name(name)
    return builder.build()
}
