@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.inputs

import com.pulumi.aws.comprehend.inputs.DocumentClassifierInputDataConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property augmentedManifests List of training datasets produced by Amazon SageMaker Ground Truth.
 * Used if `data_format` is `AUGMENTED_MANIFEST`.
 * See the `augmented_manifests` Configuration Block section below.
 * @property dataFormat The format for the training data.
 * One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
 * @property labelDelimiter Delimiter between labels when training a multi-label classifier.
 * Valid values are `|`, `~`, `!`, `@`, `#`, `$`, `%`, `^`, `*`, `-`, `_`, `+`, `=`, `\`, `:`, `;`, `>`, `?`, `/`, `<space>`, and `<tab>`.
 * Default is `|`.
 * @property s3Uri Location of training documents.
 * Used if `data_format` is `COMPREHEND_CSV`.
 * @property testS3Uri
 */
public data class DocumentClassifierInputDataConfigArgs(
    public val augmentedManifests:
    Output<List<DocumentClassifierInputDataConfigAugmentedManifestArgs>>? = null,
    public val dataFormat: Output<String>? = null,
    public val labelDelimiter: Output<String>? = null,
    public val s3Uri: Output<String>? = null,
    public val testS3Uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.comprehend.inputs.DocumentClassifierInputDataConfigArgs> {
    override fun toJava(): com.pulumi.aws.comprehend.inputs.DocumentClassifierInputDataConfigArgs =
        com.pulumi.aws.comprehend.inputs.DocumentClassifierInputDataConfigArgs.builder()
            .augmentedManifests(
                augmentedManifests?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .dataFormat(dataFormat?.applyValue({ args0 -> args0 }))
            .labelDelimiter(labelDelimiter?.applyValue({ args0 -> args0 }))
            .s3Uri(s3Uri?.applyValue({ args0 -> args0 }))
            .testS3Uri(testS3Uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DocumentClassifierInputDataConfigArgs].
 */
@PulumiTagMarker
public class DocumentClassifierInputDataConfigArgsBuilder internal constructor() {
    private var augmentedManifests:
        Output<List<DocumentClassifierInputDataConfigAugmentedManifestArgs>>? = null

    private var dataFormat: Output<String>? = null

    private var labelDelimiter: Output<String>? = null

    private var s3Uri: Output<String>? = null

    private var testS3Uri: Output<String>? = null

    /**
     * @param value List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("rcertwjagpmiixye")
    public suspend
    fun augmentedManifests(`value`: Output<List<DocumentClassifierInputDataConfigAugmentedManifestArgs>>) {
        this.augmentedManifests = value
    }

    @JvmName("dvoiwwgdkmvelkwy")
    public suspend fun augmentedManifests(
        vararg
        values: Output<DocumentClassifierInputDataConfigAugmentedManifestArgs>,
    ) {
        this.augmentedManifests = Output.all(values.asList())
    }

    /**
     * @param values List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("gnwlyiixdkvspvbv")
    public suspend
    fun augmentedManifests(values: List<Output<DocumentClassifierInputDataConfigAugmentedManifestArgs>>) {
        this.augmentedManifests = Output.all(values)
    }

    /**
     * @param value The format for the training data.
     * One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
     */
    @JvmName("lyehlyehrwgayeph")
    public suspend fun dataFormat(`value`: Output<String>) {
        this.dataFormat = value
    }

    /**
     * @param value Delimiter between labels when training a multi-label classifier.
     * Valid values are `|`, `~`, `!`, `@`, `#`, `$`, `%`, `^`, `*`, `-`, `_`, `+`, `=`, `\`, `:`, `;`, `>`, `?`, `/`, `<space>`, and `<tab>`.
     * Default is `|`.
     */
    @JvmName("ovfcvhgivdbuofua")
    public suspend fun labelDelimiter(`value`: Output<String>) {
        this.labelDelimiter = value
    }

    /**
     * @param value Location of training documents.
     * Used if `data_format` is `COMPREHEND_CSV`.
     */
    @JvmName("yghpgbfxafgtgdqu")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value
     */
    @JvmName("hdmidxahyulveydu")
    public suspend fun testS3Uri(`value`: Output<String>) {
        this.testS3Uri = value
    }

    /**
     * @param value List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("hsckbuwjhqnbjktd")
    public suspend
    fun augmentedManifests(`value`: List<DocumentClassifierInputDataConfigAugmentedManifestArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.augmentedManifests = mapped
    }

    /**
     * @param argument List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("ywnmngkrmiqfloew")
    public suspend
    fun augmentedManifests(argument: List<suspend DocumentClassifierInputDataConfigAugmentedManifestArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DocumentClassifierInputDataConfigAugmentedManifestArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.augmentedManifests = mapped
    }

    /**
     * @param argument List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("xnhhpfqonrlpjhsk")
    public suspend fun augmentedManifests(
        vararg
        argument: suspend DocumentClassifierInputDataConfigAugmentedManifestArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DocumentClassifierInputDataConfigAugmentedManifestArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.augmentedManifests = mapped
    }

    /**
     * @param argument List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("jciudyddjcnkgnbv")
    public suspend
    fun augmentedManifests(argument: suspend DocumentClassifierInputDataConfigAugmentedManifestArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DocumentClassifierInputDataConfigAugmentedManifestArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.augmentedManifests = mapped
    }

    /**
     * @param values List of training datasets produced by Amazon SageMaker Ground Truth.
     * Used if `data_format` is `AUGMENTED_MANIFEST`.
     * See the `augmented_manifests` Configuration Block section below.
     */
    @JvmName("ouivyalckwftmuxs")
    public suspend fun augmentedManifests(
        vararg
        values: DocumentClassifierInputDataConfigAugmentedManifestArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.augmentedManifests = mapped
    }

    /**
     * @param value The format for the training data.
     * One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
     */
    @JvmName("eweitgbosqrqcspg")
    public suspend fun dataFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataFormat = mapped
    }

    /**
     * @param value Delimiter between labels when training a multi-label classifier.
     * Valid values are `|`, `~`, `!`, `@`, `#`, `$`, `%`, `^`, `*`, `-`, `_`, `+`, `=`, `\`, `:`, `;`, `>`, `?`, `/`, `<space>`, and `<tab>`.
     * Default is `|`.
     */
    @JvmName("rfssjbhjdxfdrdkm")
    public suspend fun labelDelimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelDelimiter = mapped
    }

    /**
     * @param value Location of training documents.
     * Used if `data_format` is `COMPREHEND_CSV`.
     */
    @JvmName("truowvxqsxiptixp")
    public suspend fun s3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    /**
     * @param value
     */
    @JvmName("ayvkajvkykfaykml")
    public suspend fun testS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testS3Uri = mapped
    }

    internal fun build(): DocumentClassifierInputDataConfigArgs =
        DocumentClassifierInputDataConfigArgs(
            augmentedManifests = augmentedManifests,
            dataFormat = dataFormat,
            labelDelimiter = labelDelimiter,
            s3Uri = s3Uri,
            testS3Uri = testS3Uri,
        )
}
