@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.inputs

import com.pulumi.aws.comprehend.inputs.DocumentClassifierInputDataConfigAugmentedManifestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property annotationDataS3Uri Location of annotation files.
 * @property attributeNames The JSON attribute that contains the annotations for the training documents.
 * @property documentType Type of augmented manifest.
 * One of `PLAIN_TEXT_DOCUMENT` or `SEMI_STRUCTURED_DOCUMENT`.
 * @property s3Uri Location of augmented manifest file.
 * @property sourceDocumentsS3Uri Location of source PDF files.
 * @property split Purpose of data in augmented manifest.
 * One of `TRAIN` or `TEST`.
 */
public data class DocumentClassifierInputDataConfigAugmentedManifestArgs(
    public val annotationDataS3Uri: Output<String>? = null,
    public val attributeNames: Output<List<String>>,
    public val documentType: Output<String>? = null,
    public val s3Uri: Output<String>,
    public val sourceDocumentsS3Uri: Output<String>? = null,
    public val split: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.comprehend.inputs.DocumentClassifierInputDataConfigAugmentedManifestArgs> {
    override fun toJava():
        com.pulumi.aws.comprehend.inputs.DocumentClassifierInputDataConfigAugmentedManifestArgs =
        com.pulumi.aws.comprehend.inputs.DocumentClassifierInputDataConfigAugmentedManifestArgs.builder()
            .annotationDataS3Uri(annotationDataS3Uri?.applyValue({ args0 -> args0 }))
            .attributeNames(attributeNames.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .documentType(documentType?.applyValue({ args0 -> args0 }))
            .s3Uri(s3Uri.applyValue({ args0 -> args0 }))
            .sourceDocumentsS3Uri(sourceDocumentsS3Uri?.applyValue({ args0 -> args0 }))
            .split(split?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DocumentClassifierInputDataConfigAugmentedManifestArgs].
 */
@PulumiTagMarker
public class DocumentClassifierInputDataConfigAugmentedManifestArgsBuilder internal constructor() {
    private var annotationDataS3Uri: Output<String>? = null

    private var attributeNames: Output<List<String>>? = null

    private var documentType: Output<String>? = null

    private var s3Uri: Output<String>? = null

    private var sourceDocumentsS3Uri: Output<String>? = null

    private var split: Output<String>? = null

    /**
     * @param value Location of annotation files.
     */
    @JvmName("nkcsvwxartfmffqp")
    public suspend fun annotationDataS3Uri(`value`: Output<String>) {
        this.annotationDataS3Uri = value
    }

    /**
     * @param value The JSON attribute that contains the annotations for the training documents.
     */
    @JvmName("btsymwpbdfvamfps")
    public suspend fun attributeNames(`value`: Output<List<String>>) {
        this.attributeNames = value
    }

    @JvmName("elytviuaspidlcks")
    public suspend fun attributeNames(vararg values: Output<String>) {
        this.attributeNames = Output.all(values.asList())
    }

    /**
     * @param values The JSON attribute that contains the annotations for the training documents.
     */
    @JvmName("xifgswwouhcjpybf")
    public suspend fun attributeNames(values: List<Output<String>>) {
        this.attributeNames = Output.all(values)
    }

    /**
     * @param value Type of augmented manifest.
     * One of `PLAIN_TEXT_DOCUMENT` or `SEMI_STRUCTURED_DOCUMENT`.
     */
    @JvmName("clinmitdsynetpfm")
    public suspend fun documentType(`value`: Output<String>) {
        this.documentType = value
    }

    /**
     * @param value Location of augmented manifest file.
     */
    @JvmName("rtoukwsbosrhppnd")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value Location of source PDF files.
     */
    @JvmName("lkbypqvljsfyavsp")
    public suspend fun sourceDocumentsS3Uri(`value`: Output<String>) {
        this.sourceDocumentsS3Uri = value
    }

    /**
     * @param value Purpose of data in augmented manifest.
     * One of `TRAIN` or `TEST`.
     */
    @JvmName("vqlgjiqkmpgqoyjb")
    public suspend fun split(`value`: Output<String>) {
        this.split = value
    }

    /**
     * @param value Location of annotation files.
     */
    @JvmName("cyvcoteccxcbsmxt")
    public suspend fun annotationDataS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotationDataS3Uri = mapped
    }

    /**
     * @param value The JSON attribute that contains the annotations for the training documents.
     */
    @JvmName("yyevqbwkysdlunrf")
    public suspend fun attributeNames(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeNames = mapped
    }

    /**
     * @param values The JSON attribute that contains the annotations for the training documents.
     */
    @JvmName("wajrjkhnxnabbwkv")
    public suspend fun attributeNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeNames = mapped
    }

    /**
     * @param value Type of augmented manifest.
     * One of `PLAIN_TEXT_DOCUMENT` or `SEMI_STRUCTURED_DOCUMENT`.
     */
    @JvmName("najnhwnbnqevrqjb")
    public suspend fun documentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentType = mapped
    }

    /**
     * @param value Location of augmented manifest file.
     */
    @JvmName("cdoaacxkpvohmqmo")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    /**
     * @param value Location of source PDF files.
     */
    @JvmName("mjnxrhwqpcaihgon")
    public suspend fun sourceDocumentsS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDocumentsS3Uri = mapped
    }

    /**
     * @param value Purpose of data in augmented manifest.
     * One of `TRAIN` or `TEST`.
     */
    @JvmName("lvtjudfplagcpbsl")
    public suspend fun split(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.split = mapped
    }

    internal fun build(): DocumentClassifierInputDataConfigAugmentedManifestArgs =
        DocumentClassifierInputDataConfigAugmentedManifestArgs(
            annotationDataS3Uri = annotationDataS3Uri,
            attributeNames = attributeNames ?: throw PulumiNullFieldException("attributeNames"),
            documentType = documentType,
            s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
            sourceDocumentsS3Uri = sourceDocumentsS3Uri,
            split = split,
        )
}
