@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.inputs

import com.pulumi.aws.comprehend.inputs.DocumentClassifierOutputDataConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId KMS Key used to encrypt the output documents.
 * Can be a KMS Key ID, a KMS Key ARN, a KMS Alias name, or a KMS Alias ARN.
 * @property outputS3Uri Full path for the output documents.
 * @property s3Uri Destination path for the output documents.
 * The full path to the output file will be returned in `output_s3_uri`.
 */
public data class DocumentClassifierOutputDataConfigArgs(
    public val kmsKeyId: Output<String>? = null,
    public val outputS3Uri: Output<String>? = null,
    public val s3Uri: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.comprehend.inputs.DocumentClassifierOutputDataConfigArgs> {
    override fun toJava(): com.pulumi.aws.comprehend.inputs.DocumentClassifierOutputDataConfigArgs =
        com.pulumi.aws.comprehend.inputs.DocumentClassifierOutputDataConfigArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .outputS3Uri(outputS3Uri?.applyValue({ args0 -> args0 }))
            .s3Uri(s3Uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DocumentClassifierOutputDataConfigArgs].
 */
@PulumiTagMarker
public class DocumentClassifierOutputDataConfigArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var outputS3Uri: Output<String>? = null

    private var s3Uri: Output<String>? = null

    /**
     * @param value KMS Key used to encrypt the output documents.
     * Can be a KMS Key ID, a KMS Key ARN, a KMS Alias name, or a KMS Alias ARN.
     */
    @JvmName("ugimsfcmojgtdjwf")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Full path for the output documents.
     */
    @JvmName("wvjnxquohgumoloj")
    public suspend fun outputS3Uri(`value`: Output<String>) {
        this.outputS3Uri = value
    }

    /**
     * @param value Destination path for the output documents.
     * The full path to the output file will be returned in `output_s3_uri`.
     */
    @JvmName("mwyeqrglruiuoaov")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value KMS Key used to encrypt the output documents.
     * Can be a KMS Key ID, a KMS Key ARN, a KMS Alias name, or a KMS Alias ARN.
     */
    @JvmName("wajeocnhnlfmsfpj")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Full path for the output documents.
     */
    @JvmName("iurkxfuyqsbieptc")
    public suspend fun outputS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outputS3Uri = mapped
    }

    /**
     * @param value Destination path for the output documents.
     * The full path to the output file will be returned in `output_s3_uri`.
     */
    @JvmName("lomkbysqxhbuedhl")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    internal fun build(): DocumentClassifierOutputDataConfigArgs =
        DocumentClassifierOutputDataConfigArgs(
            kmsKeyId = kmsKeyId,
            outputS3Uri = outputS3Uri,
            s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
        )
}
