@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.inputs

import com.pulumi.aws.comprehend.inputs.DocumentClassifierVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds List of security group IDs.
 * @property subnets List of VPC subnets.
 */
public data class DocumentClassifierVpcConfigArgs(
    public val securityGroupIds: Output<List<String>>,
    public val subnets: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.comprehend.inputs.DocumentClassifierVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.comprehend.inputs.DocumentClassifierVpcConfigArgs =
        com.pulumi.aws.comprehend.inputs.DocumentClassifierVpcConfigArgs.builder()
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DocumentClassifierVpcConfigArgs].
 */
@PulumiTagMarker
public class DocumentClassifierVpcConfigArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    /**
     * @param value List of security group IDs.
     */
    @JvmName("qbcncymghssjtqqx")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("dcgbwnmtdfbhxjgw")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of security group IDs.
     */
    @JvmName("evxoqfjolatfreta")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value List of VPC subnets.
     */
    @JvmName("iqqyxmdyabwpsikx")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("nvrentyredomldoe")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values List of VPC subnets.
     */
    @JvmName("ndxuerjsgdxvybco")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value List of security group IDs.
     */
    @JvmName("tvuiuylogeytfhue")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values List of security group IDs.
     */
    @JvmName("hkvmywojyoihaljr")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value List of VPC subnets.
     */
    @JvmName("syeaqxlqxmqydhca")
    public suspend fun subnets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values List of VPC subnets.
     */
    @JvmName("tryghatuudpvjduc")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    internal fun build(): DocumentClassifierVpcConfigArgs = DocumentClassifierVpcConfigArgs(
        securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
        subnets = subnets ?: throw PulumiNullFieldException("subnets"),
    )
}
