@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.inputs

import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigAnnotationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3Uri Location of training annotations.
 * @property testS3Uri
 */
public data class EntityRecognizerInputDataConfigAnnotationsArgs(
    public val s3Uri: Output<String>,
    public val testS3Uri: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigAnnotationsArgs> {
    override fun toJava():
        com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigAnnotationsArgs =
        com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigAnnotationsArgs.builder()
            .s3Uri(s3Uri.applyValue({ args0 -> args0 }))
            .testS3Uri(testS3Uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EntityRecognizerInputDataConfigAnnotationsArgs].
 */
@PulumiTagMarker
public class EntityRecognizerInputDataConfigAnnotationsArgsBuilder internal constructor() {
    private var s3Uri: Output<String>? = null

    private var testS3Uri: Output<String>? = null

    /**
     * @param value Location of training annotations.
     */
    @JvmName("muettnskbcjmvmup")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value
     */
    @JvmName("tydmxrmgftsabntj")
    public suspend fun testS3Uri(`value`: Output<String>) {
        this.testS3Uri = value
    }

    /**
     * @param value Location of training annotations.
     */
    @JvmName("svxmsvvqjmoeibgm")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    /**
     * @param value
     */
    @JvmName("rgljkwwihcsifntp")
    public suspend fun testS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testS3Uri = mapped
    }

    internal fun build(): EntityRecognizerInputDataConfigAnnotationsArgs =
        EntityRecognizerInputDataConfigAnnotationsArgs(
            s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
            testS3Uri = testS3Uri,
        )
}
