@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.inputs

import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigAugmentedManifestArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property annotationDataS3Uri Location of annotation files.
 * @property attributeNames The JSON attribute that contains the annotations for the training documents.
 * @property documentType Type of augmented manifest.
 * One of `PLAIN_TEXT_DOCUMENT` or `SEMI_STRUCTURED_DOCUMENT`.
 * @property s3Uri Location of augmented manifest file.
 * @property sourceDocumentsS3Uri Location of source PDF files.
 * @property split Purpose of data in augmented manifest.
 * One of `TRAIN` or `TEST`.
 */
public data class EntityRecognizerInputDataConfigAugmentedManifestArgs(
    public val annotationDataS3Uri: Output<String>? = null,
    public val attributeNames: Output<List<String>>,
    public val documentType: Output<String>? = null,
    public val s3Uri: Output<String>,
    public val sourceDocumentsS3Uri: Output<String>? = null,
    public val split: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigAugmentedManifestArgs> {
    override fun toJava():
        com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigAugmentedManifestArgs =
        com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigAugmentedManifestArgs.builder()
            .annotationDataS3Uri(annotationDataS3Uri?.applyValue({ args0 -> args0 }))
            .attributeNames(attributeNames.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .documentType(documentType?.applyValue({ args0 -> args0 }))
            .s3Uri(s3Uri.applyValue({ args0 -> args0 }))
            .sourceDocumentsS3Uri(sourceDocumentsS3Uri?.applyValue({ args0 -> args0 }))
            .split(split?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EntityRecognizerInputDataConfigAugmentedManifestArgs].
 */
@PulumiTagMarker
public class EntityRecognizerInputDataConfigAugmentedManifestArgsBuilder internal constructor() {
    private var annotationDataS3Uri: Output<String>? = null

    private var attributeNames: Output<List<String>>? = null

    private var documentType: Output<String>? = null

    private var s3Uri: Output<String>? = null

    private var sourceDocumentsS3Uri: Output<String>? = null

    private var split: Output<String>? = null

    /**
     * @param value Location of annotation files.
     */
    @JvmName("rjhdlgukmnslcbjm")
    public suspend fun annotationDataS3Uri(`value`: Output<String>) {
        this.annotationDataS3Uri = value
    }

    /**
     * @param value The JSON attribute that contains the annotations for the training documents.
     */
    @JvmName("eruyrhjfxdukdlhm")
    public suspend fun attributeNames(`value`: Output<List<String>>) {
        this.attributeNames = value
    }

    @JvmName("ktpiqaeeewcslyjh")
    public suspend fun attributeNames(vararg values: Output<String>) {
        this.attributeNames = Output.all(values.asList())
    }

    /**
     * @param values The JSON attribute that contains the annotations for the training documents.
     */
    @JvmName("cdgiclvngqhjkitr")
    public suspend fun attributeNames(values: List<Output<String>>) {
        this.attributeNames = Output.all(values)
    }

    /**
     * @param value Type of augmented manifest.
     * One of `PLAIN_TEXT_DOCUMENT` or `SEMI_STRUCTURED_DOCUMENT`.
     */
    @JvmName("pchtorigcsniybxi")
    public suspend fun documentType(`value`: Output<String>) {
        this.documentType = value
    }

    /**
     * @param value Location of augmented manifest file.
     */
    @JvmName("nhovbkepreegjdcs")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value Location of source PDF files.
     */
    @JvmName("upsyrufdaxxfynqo")
    public suspend fun sourceDocumentsS3Uri(`value`: Output<String>) {
        this.sourceDocumentsS3Uri = value
    }

    /**
     * @param value Purpose of data in augmented manifest.
     * One of `TRAIN` or `TEST`.
     */
    @JvmName("dhiwynwlveuwwyvw")
    public suspend fun split(`value`: Output<String>) {
        this.split = value
    }

    /**
     * @param value Location of annotation files.
     */
    @JvmName("wbdxgomfwcstklwj")
    public suspend fun annotationDataS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotationDataS3Uri = mapped
    }

    /**
     * @param value The JSON attribute that contains the annotations for the training documents.
     */
    @JvmName("jtjixqqijtfknqiw")
    public suspend fun attributeNames(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeNames = mapped
    }

    /**
     * @param values The JSON attribute that contains the annotations for the training documents.
     */
    @JvmName("awoykblteumqtogb")
    public suspend fun attributeNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeNames = mapped
    }

    /**
     * @param value Type of augmented manifest.
     * One of `PLAIN_TEXT_DOCUMENT` or `SEMI_STRUCTURED_DOCUMENT`.
     */
    @JvmName("vpddjlsafaiopiyu")
    public suspend fun documentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.documentType = mapped
    }

    /**
     * @param value Location of augmented manifest file.
     */
    @JvmName("nchxfeyocnafiwrb")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    /**
     * @param value Location of source PDF files.
     */
    @JvmName("illlvllndmgvvdfg")
    public suspend fun sourceDocumentsS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDocumentsS3Uri = mapped
    }

    /**
     * @param value Purpose of data in augmented manifest.
     * One of `TRAIN` or `TEST`.
     */
    @JvmName("wfdtkuujjoxxkhqv")
    public suspend fun split(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.split = mapped
    }

    internal fun build(): EntityRecognizerInputDataConfigAugmentedManifestArgs =
        EntityRecognizerInputDataConfigAugmentedManifestArgs(
            annotationDataS3Uri = annotationDataS3Uri,
            attributeNames = attributeNames ?: throw PulumiNullFieldException("attributeNames"),
            documentType = documentType,
            s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
            sourceDocumentsS3Uri = sourceDocumentsS3Uri,
            split = split,
        )
}
