@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.inputs

import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigDocumentsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property inputFormat Specifies how the input files should be processed.
 * One of `ONE_DOC_PER_LINE` or `ONE_DOC_PER_FILE`.
 * @property s3Uri Location of training documents.
 * @property testS3Uri
 */
public data class EntityRecognizerInputDataConfigDocumentsArgs(
    public val inputFormat: Output<String>? = null,
    public val s3Uri: Output<String>,
    public val testS3Uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigDocumentsArgs> {
    override fun toJava():
        com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigDocumentsArgs =
        com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigDocumentsArgs.builder()
            .inputFormat(inputFormat?.applyValue({ args0 -> args0 }))
            .s3Uri(s3Uri.applyValue({ args0 -> args0 }))
            .testS3Uri(testS3Uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EntityRecognizerInputDataConfigDocumentsArgs].
 */
@PulumiTagMarker
public class EntityRecognizerInputDataConfigDocumentsArgsBuilder internal constructor() {
    private var inputFormat: Output<String>? = null

    private var s3Uri: Output<String>? = null

    private var testS3Uri: Output<String>? = null

    /**
     * @param value Specifies how the input files should be processed.
     * One of `ONE_DOC_PER_LINE` or `ONE_DOC_PER_FILE`.
     */
    @JvmName("nriwpsgyqjilfxok")
    public suspend fun inputFormat(`value`: Output<String>) {
        this.inputFormat = value
    }

    /**
     * @param value Location of training documents.
     */
    @JvmName("gowbmkhwcabkicou")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value
     */
    @JvmName("ewufjrpybqrmblcx")
    public suspend fun testS3Uri(`value`: Output<String>) {
        this.testS3Uri = value
    }

    /**
     * @param value Specifies how the input files should be processed.
     * One of `ONE_DOC_PER_LINE` or `ONE_DOC_PER_FILE`.
     */
    @JvmName("pbeeindttrxughbq")
    public suspend fun inputFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputFormat = mapped
    }

    /**
     * @param value Location of training documents.
     */
    @JvmName("musvplypinegvcni")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    /**
     * @param value
     */
    @JvmName("jcvqaqplukpmompg")
    public suspend fun testS3Uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testS3Uri = mapped
    }

    internal fun build(): EntityRecognizerInputDataConfigDocumentsArgs =
        EntityRecognizerInputDataConfigDocumentsArgs(
            inputFormat = inputFormat,
            s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
            testS3Uri = testS3Uri,
        )
}
