@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.inputs

import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigEntityListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3Uri Location of entity list.
 */
public data class EntityRecognizerInputDataConfigEntityListArgs(
    public val s3Uri: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigEntityListArgs> {
    override fun toJava():
        com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigEntityListArgs =
        com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigEntityListArgs.builder()
            .s3Uri(s3Uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EntityRecognizerInputDataConfigEntityListArgs].
 */
@PulumiTagMarker
public class EntityRecognizerInputDataConfigEntityListArgsBuilder internal constructor() {
    private var s3Uri: Output<String>? = null

    /**
     * @param value Location of entity list.
     */
    @JvmName("rxpbvatuuelplajf")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value Location of entity list.
     */
    @JvmName("vocppphyvfdqefxr")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    internal fun build(): EntityRecognizerInputDataConfigEntityListArgs =
        EntityRecognizerInputDataConfigEntityListArgs(
            s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
        )
}
