@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.inputs

import com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigEntityTypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type An entity type to be matched by the Entity Recognizer.
 * Cannot contain a newline (`\n`), carriage return (`\r`), or tab (`\t`).
 */
public data class EntityRecognizerInputDataConfigEntityTypeArgs(
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigEntityTypeArgs> {
    override fun toJava():
        com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigEntityTypeArgs =
        com.pulumi.aws.comprehend.inputs.EntityRecognizerInputDataConfigEntityTypeArgs.builder()
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EntityRecognizerInputDataConfigEntityTypeArgs].
 */
@PulumiTagMarker
public class EntityRecognizerInputDataConfigEntityTypeArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    /**
     * @param value An entity type to be matched by the Entity Recognizer.
     * Cannot contain a newline (`\n`), carriage return (`\r`), or tab (`\t`).
     */
    @JvmName("wqembxwwlsqijcvb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value An entity type to be matched by the Entity Recognizer.
     * Cannot contain a newline (`\n`), carriage return (`\r`), or tab (`\t`).
     */
    @JvmName("qinxnotuolwwipmj")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EntityRecognizerInputDataConfigEntityTypeArgs =
        EntityRecognizerInputDataConfigEntityTypeArgs(
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
