@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property annotations Specifies location of the document annotation data.
 * See the `annotations` Configuration Block section below.
 * One of `annotations` or `entity_list` is required.
 * @property augmentedManifests List of training datasets produced by Amazon SageMaker Ground Truth.
 * Used if `data_format` is `AUGMENTED_MANIFEST`.
 * See the `augmented_manifests` Configuration Block section below.
 * @property dataFormat The format for the training data.
 * One of `COMPREHEND_CSV` or `AUGMENTED_MANIFEST`.
 * @property documents Specifies a collection of training documents.
 * Used if `data_format` is `COMPREHEND_CSV`.
 * See the `documents` Configuration Block section below.
 * @property entityList Specifies location of the entity list data.
 * See the `entity_list` Configuration Block section below.
 * One of `entity_list` or `annotations` is required.
 * @property entityTypes Set of entity types to be recognized.
 * Has a maximum of 25 items.
 * See the `entity_types` Configuration Block section below.
 */
public data class EntityRecognizerInputDataConfig(
    public val annotations: EntityRecognizerInputDataConfigAnnotations? = null,
    public val augmentedManifests: List<EntityRecognizerInputDataConfigAugmentedManifest>? = null,
    public val dataFormat: String? = null,
    public val documents: EntityRecognizerInputDataConfigDocuments? = null,
    public val entityList: EntityRecognizerInputDataConfigEntityList? = null,
    public val entityTypes: List<EntityRecognizerInputDataConfigEntityType>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.comprehend.outputs.EntityRecognizerInputDataConfig):
            EntityRecognizerInputDataConfig = EntityRecognizerInputDataConfig(
            annotations = javaType.annotations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.comprehend.kotlin.outputs.EntityRecognizerInputDataConfigAnnotations.Companion.toKotlin(args0)
                })
            }).orElse(null),
            augmentedManifests = javaType.augmentedManifests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.comprehend.kotlin.outputs.EntityRecognizerInputDataConfigAugmentedManifest.Companion.toKotlin(args0)
                })
            }),
            dataFormat = javaType.dataFormat().map({ args0 -> args0 }).orElse(null),
            documents = javaType.documents().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.comprehend.kotlin.outputs.EntityRecognizerInputDataConfigDocuments.Companion.toKotlin(args0)
                })
            }).orElse(null),
            entityList = javaType.entityList().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.comprehend.kotlin.outputs.EntityRecognizerInputDataConfigEntityList.Companion.toKotlin(args0)
                })
            }).orElse(null),
            entityTypes = javaType.entityTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.comprehend.kotlin.outputs.EntityRecognizerInputDataConfigEntityType.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
