@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property inputFormat Specifies how the input files should be processed.
 * One of `ONE_DOC_PER_LINE` or `ONE_DOC_PER_FILE`.
 * @property s3Uri Location of training documents.
 * @property testS3Uri
 */
public data class EntityRecognizerInputDataConfigDocuments(
    public val inputFormat: String? = null,
    public val s3Uri: String,
    public val testS3Uri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.comprehend.outputs.EntityRecognizerInputDataConfigDocuments):
            EntityRecognizerInputDataConfigDocuments = EntityRecognizerInputDataConfigDocuments(
            inputFormat = javaType.inputFormat().map({ args0 -> args0 }).orElse(null),
            s3Uri = javaType.s3Uri(),
            testS3Uri = javaType.testS3Uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
