@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.comprehend.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds List of security group IDs.
 * @property subnets List of VPC subnets.
 */
public data class EntityRecognizerVpcConfig(
    public val securityGroupIds: List<String>,
    public val subnets: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.comprehend.outputs.EntityRecognizerVpcConfig):
            EntityRecognizerVpcConfig = EntityRecognizerVpcConfig(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnets = javaType.subnets().map({ args0 -> args0 }),
        )
    }
}
