@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.BotAssociationLexBot
import com.pulumi.aws.connect.kotlin.outputs.BotAssociationLexBot.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BotAssociation].
 */
@PulumiTagMarker
public class BotAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BotAssociationArgs = BotAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BotAssociationArgsBuilder.() -> Unit) {
        val builder = BotAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BotAssociation {
        val builtJavaResource = com.pulumi.aws.connect.BotAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BotAssociation(builtJavaResource)
    }
}

/**
 * Allows the specified Amazon Connect instance to access the specified Amazon Lex (V1) bot. For more information see
 * [Amazon Connect: Getting Started](https://docs&#46;aws&#46;amazon&#46;com/connect/latest/adminguide/amazon-connect-get-started&#46;html) and [Add an Amazon Lex bot](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-lex.html).
 * > **NOTE:** This resource only currently supports Amazon Lex (V1) Associations.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.BotAssociation;
 * import com.pulumi.aws.connect.BotAssociationArgs;
 * import com.pulumi.aws.connect.inputs.BotAssociationLexBotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BotAssociation("example", BotAssociationArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .lexBot(BotAssociationLexBotArgs.builder()
 *                 .lexRegion("us-west-2")
 *                 .name("Test")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Including a sample Lex bot
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.lex.Intent;
 * import com.pulumi.aws.lex.IntentArgs;
 * import com.pulumi.aws.lex.inputs.IntentFulfillmentActivityArgs;
 * import com.pulumi.aws.lex.Bot;
 * import com.pulumi.aws.lex.BotArgs;
 * import com.pulumi.aws.lex.inputs.BotAbortStatementArgs;
 * import com.pulumi.aws.lex.inputs.BotClarificationPromptArgs;
 * import com.pulumi.aws.lex.inputs.BotIntentArgs;
 * import com.pulumi.aws.connect.BotAssociation;
 * import com.pulumi.aws.connect.BotAssociationArgs;
 * import com.pulumi.aws.connect.inputs.BotAssociationLexBotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleIntent = new Intent("exampleIntent", IntentArgs.builder()
 *             .createVersion(true)
 *             .name("connect_lex_intent")
 *             .fulfillmentActivity(IntentFulfillmentActivityArgs.builder()
 *                 .type("ReturnIntent")
 *                 .build())
 *             .sampleUtterances("I would like to pick up flowers.")
 *             .build());
 *         var exampleBot = new Bot("exampleBot", BotArgs.builder()
 *             .abortStatement(BotAbortStatementArgs.builder()
 *                 .messages(BotAbortStatementMessageArgs.builder()
 *                     .content("Sorry, I am not able to assist at this time.")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .clarificationPrompt(BotClarificationPromptArgs.builder()
 *                 .maxAttempts(2)
 *                 .messages(BotClarificationPromptMessageArgs.builder()
 *                     .content("I didn't understand you, what would you like to do?")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .intents(BotIntentArgs.builder()
 *                 .intentName(exampleIntent.name())
 *                 .intentVersion("1")
 *                 .build())
 *             .childDirected(false)
 *             .name("connect_lex_bot")
 *             .processBehavior("BUILD")
 *             .build());
 *         var exampleBotAssociation = new BotAssociation("exampleBotAssociation", BotAssociationArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .lexBot(BotAssociationLexBotArgs.builder()
 *                 .lexRegion(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .name(exampleBot.name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_connect_bot_association` using the Amazon Connect instance ID, Lex (V1) bot name, and Lex (V1) bot region separated by colons (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/botAssociation:BotAssociation example aaaaaaaa-bbbb-cccc-dddd-111111111111:Example:us-west-2
 * ```
 *
 */
public class BotAssociation internal constructor(
    override val javaResource: com.pulumi.aws.connect.BotAssociation,
) : KotlinCustomResource(javaResource, BotAssociationMapper) {
    /**
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Configuration information of an Amazon Lex (V1) bot. Detailed below.
     */
    public val lexBot: Output<BotAssociationLexBot>
        get() = javaResource.lexBot().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object BotAssociationMapper : ResourceMapper<BotAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.BotAssociation::class == javaResource::class

    override fun map(javaResource: Resource): BotAssociation = BotAssociation(
        javaResource as
            com.pulumi.aws.connect.BotAssociation,
    )
}

/**
 * @see [BotAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BotAssociation].
 */
public suspend fun botAssociation(
    name: String,
    block: suspend BotAssociationResourceBuilder.() -> Unit,
): BotAssociation {
    val builder = BotAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BotAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun botAssociation(name: String): BotAssociation {
    val builder = BotAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
