@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.BotAssociationArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.BotAssociationLexBotArgs
import com.pulumi.aws.connect.kotlin.inputs.BotAssociationLexBotArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Allows the specified Amazon Connect instance to access the specified Amazon Lex (V1) bot. For more information see
 * [Amazon Connect: Getting Started](https://docs&#46;aws&#46;amazon&#46;com/connect/latest/adminguide/amazon-connect-get-started&#46;html) and [Add an Amazon Lex bot](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-lex.html).
 * > **NOTE:** This resource only currently supports Amazon Lex (V1) Associations.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.BotAssociation;
 * import com.pulumi.aws.connect.BotAssociationArgs;
 * import com.pulumi.aws.connect.inputs.BotAssociationLexBotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BotAssociation("example", BotAssociationArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .lexBot(BotAssociationLexBotArgs.builder()
 *                 .lexRegion("us-west-2")
 *                 .name("Test")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Including a sample Lex bot
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetRegionArgs;
 * import com.pulumi.aws.lex.Intent;
 * import com.pulumi.aws.lex.IntentArgs;
 * import com.pulumi.aws.lex.inputs.IntentFulfillmentActivityArgs;
 * import com.pulumi.aws.lex.Bot;
 * import com.pulumi.aws.lex.BotArgs;
 * import com.pulumi.aws.lex.inputs.BotAbortStatementArgs;
 * import com.pulumi.aws.lex.inputs.BotClarificationPromptArgs;
 * import com.pulumi.aws.lex.inputs.BotIntentArgs;
 * import com.pulumi.aws.connect.BotAssociation;
 * import com.pulumi.aws.connect.BotAssociationArgs;
 * import com.pulumi.aws.connect.inputs.BotAssociationLexBotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getRegion();
 *         var exampleIntent = new Intent("exampleIntent", IntentArgs.builder()
 *             .createVersion(true)
 *             .name("connect_lex_intent")
 *             .fulfillmentActivity(IntentFulfillmentActivityArgs.builder()
 *                 .type("ReturnIntent")
 *                 .build())
 *             .sampleUtterances("I would like to pick up flowers.")
 *             .build());
 *         var exampleBot = new Bot("exampleBot", BotArgs.builder()
 *             .abortStatement(BotAbortStatementArgs.builder()
 *                 .messages(BotAbortStatementMessageArgs.builder()
 *                     .content("Sorry, I am not able to assist at this time.")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .clarificationPrompt(BotClarificationPromptArgs.builder()
 *                 .maxAttempts(2)
 *                 .messages(BotClarificationPromptMessageArgs.builder()
 *                     .content("I didn't understand you, what would you like to do?")
 *                     .contentType("PlainText")
 *                     .build())
 *                 .build())
 *             .intents(BotIntentArgs.builder()
 *                 .intentName(exampleIntent.name())
 *                 .intentVersion("1")
 *                 .build())
 *             .childDirected(false)
 *             .name("connect_lex_bot")
 *             .processBehavior("BUILD")
 *             .build());
 *         var exampleBotAssociation = new BotAssociation("exampleBotAssociation", BotAssociationArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .lexBot(BotAssociationLexBotArgs.builder()
 *                 .lexRegion(current.applyValue(getRegionResult -> getRegionResult.name()))
 *                 .name(exampleBot.name())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_connect_bot_association` using the Amazon Connect instance ID, Lex (V1) bot name, and Lex (V1) bot region separated by colons (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/botAssociation:BotAssociation example aaaaaaaa-bbbb-cccc-dddd-111111111111:Example:us-west-2
 * ```
 * @property instanceId The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
 * @property lexBot Configuration information of an Amazon Lex (V1) bot. Detailed below.
 */
public data class BotAssociationArgs(
    public val instanceId: Output<String>? = null,
    public val lexBot: Output<BotAssociationLexBotArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.BotAssociationArgs> {
    override fun toJava(): com.pulumi.aws.connect.BotAssociationArgs =
        com.pulumi.aws.connect.BotAssociationArgs.builder()
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .lexBot(lexBot?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BotAssociationArgs].
 */
@PulumiTagMarker
public class BotAssociationArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var lexBot: Output<BotAssociationLexBotArgs>? = null

    /**
     * @param value The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    @JvmName("rnwkbuciacofoqel")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Configuration information of an Amazon Lex (V1) bot. Detailed below.
     */
    @JvmName("tnkldufjhixacymm")
    public suspend fun lexBot(`value`: Output<BotAssociationLexBotArgs>) {
        this.lexBot = value
    }

    /**
     * @param value The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    @JvmName("jvbmgbffqjvasttr")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Configuration information of an Amazon Lex (V1) bot. Detailed below.
     */
    @JvmName("oesxqcsmlalbpmbk")
    public suspend fun lexBot(`value`: BotAssociationLexBotArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lexBot = mapped
    }

    /**
     * @param argument Configuration information of an Amazon Lex (V1) bot. Detailed below.
     */
    @JvmName("awopkuseatkuwaoy")
    public suspend fun lexBot(argument: suspend BotAssociationLexBotArgsBuilder.() -> Unit) {
        val toBeMapped = BotAssociationLexBotArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.lexBot = mapped
    }

    internal fun build(): BotAssociationArgs = BotAssociationArgs(
        instanceId = instanceId,
        lexBot = lexBot,
    )
}
