@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ContactFlowModule].
 */
@PulumiTagMarker
public class ContactFlowModuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContactFlowModuleArgs = ContactFlowModuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContactFlowModuleArgsBuilder.() -> Unit) {
        val builder = ContactFlowModuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ContactFlowModule {
        val builtJavaResource = com.pulumi.aws.connect.ContactFlowModule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ContactFlowModule(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect Contact Flow Module resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * This resource embeds or references Contact Flows Modules specified in Amazon Connect Contact Flow Language. For more information see
 * [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html)
 * !> **WARN:** Contact Flow Modules exported from the Console [See Contact Flow import/export which is the same for Contact Flow Modules](https://docs&#46;aws&#46;amazon&#46;com/connect/latest/adminguide/contact-flow-import-export&#46;html) are not in the Amazon Connect Contact Flow Language and can not be used with this resource&#46; Instead, the recommendation is to use the AWS CLI [`describe-contact-flow-module`](https://docs.aws.amazon.com/cli/latest/reference/connect/describe-contact-flow-module.html).
 * See example below which uses `jq` to extract the `Content` attribute and saves it to a local file.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.ContactFlowModule;
 * import com.pulumi.aws.connect.ContactFlowModuleArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactFlowModule("example", ContactFlowModuleArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .description("Example Contact Flow Module Description")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2019-10-30"),
 *                     jsonProperty("StartAction", "12345678-1234-1234-1234-123456789012"),
 *                     jsonProperty("Actions", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Identifier", "12345678-1234-1234-1234-123456789012"),
 *                             jsonProperty("Parameters", jsonObject(
 *                                 jsonProperty("Text", "Hello contact flow module")
 *                             )),
 *                             jsonProperty("Transitions", jsonObject(
 *                                 jsonProperty("NextAction", "abcdef-abcd-abcd-abcd-abcdefghijkl"),
 *                                 jsonProperty("Errors", jsonArray(
 *                                 )),
 *                                 jsonProperty("Conditions", jsonArray(
 *                                 ))
 *                             )),
 *                             jsonProperty("Type", "MessageParticipant")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Identifier", "abcdef-abcd-abcd-abcd-abcdefghijkl"),
 *                             jsonProperty("Type", "DisconnectParticipant"),
 *                             jsonProperty("Parameters", jsonObject(
 *                             )),
 *                             jsonProperty("Transitions", jsonObject(
 *                             ))
 *                         )
 *                     )),
 *                     jsonProperty("Settings", jsonObject(
 *                         jsonProperty("InputParameters", jsonArray(
 *                         )),
 *                         jsonProperty("OutputParameters", jsonArray(
 *                         )),
 *                         jsonProperty("Transitions", jsonArray(
 *                             jsonObject(
 *                                 jsonProperty("DisplayName", "Success"),
 *                                 jsonProperty("ReferenceName", "Success"),
 *                                 jsonProperty("Description", "")
 *                             ),
 *                             jsonObject(
 *                                 jsonProperty("DisplayName", "Error"),
 *                                 jsonProperty("ReferenceName", "Error"),
 *                                 jsonProperty("Description", "")
 *                             )
 *                         ))
 *                     ))
 *                 )))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "Example Contact Flow Module"),
 *                 Map.entry("Application", "Example"),
 *                 Map.entry("Method", "Create")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect Contact Flow Modules using the `instance_id` and `contact_flow_module_id` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/contactFlowModule:ContactFlowModule example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 *
 */
public class ContactFlowModule internal constructor(
    override val javaResource: com.pulumi.aws.connect.ContactFlowModule,
) : KotlinCustomResource(javaResource, ContactFlowModuleMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Contact Flow Module.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The identifier of the Contact Flow Module.
     */
    public val contactFlowModuleId: Output<String>
        get() = javaResource.contactFlowModuleId().applyValue({ args0 -> args0 })

    /**
     * Specifies the content of the Contact Flow Module, provided as a JSON string, written in Amazon Connect Contact Flow Language. If defined, the `filename` argument cannot be used.
     */
    public val content: Output<String>
        get() = javaResource.content().applyValue({ args0 -> args0 })

    /**
     * Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the Contact Flow Module source specified with `filename`.
     */
    public val contentHash: Output<String>?
        get() = javaResource.contentHash().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the description of the Contact Flow Module.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The path to the Contact Flow Module source within the local filesystem. Conflicts with `content`.
     */
    public val filename: Output<String>?
        get() = javaResource.filename().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the Contact Flow Module.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the Contact Flow Module. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ContactFlowModuleMapper : ResourceMapper<ContactFlowModule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.ContactFlowModule::class == javaResource::class

    override fun map(javaResource: Resource): ContactFlowModule = ContactFlowModule(
        javaResource as
            com.pulumi.aws.connect.ContactFlowModule,
    )
}

/**
 * @see [ContactFlowModule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ContactFlowModule].
 */
public suspend fun contactFlowModule(
    name: String,
    block: suspend ContactFlowModuleResourceBuilder.() -> Unit,
): ContactFlowModule {
    val builder = ContactFlowModuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ContactFlowModule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun contactFlowModule(name: String): ContactFlowModule {
    val builder = ContactFlowModuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
