@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.ContactFlowModuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Contact Flow Module resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * This resource embeds or references Contact Flows Modules specified in Amazon Connect Contact Flow Language. For more information see
 * [Amazon Connect Flow language](https://docs.aws.amazon.com/connect/latest/adminguide/flow-language.html)
 * !> **WARN:** Contact Flow Modules exported from the Console [See Contact Flow import/export which is the same for Contact Flow Modules](https://docs&#46;aws&#46;amazon&#46;com/connect/latest/adminguide/contact-flow-import-export&#46;html) are not in the Amazon Connect Contact Flow Language and can not be used with this resource&#46; Instead, the recommendation is to use the AWS CLI [`describe-contact-flow-module`](https://docs.aws.amazon.com/cli/latest/reference/connect/describe-contact-flow-module.html).
 * See example below which uses `jq` to extract the `Content` attribute and saves it to a local file.
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.ContactFlowModule;
 * import com.pulumi.aws.connect.ContactFlowModuleArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ContactFlowModule("example", ContactFlowModuleArgs.builder()
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .description("Example Contact Flow Module Description")
 *             .content(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2019-10-30"),
 *                     jsonProperty("StartAction", "12345678-1234-1234-1234-123456789012"),
 *                     jsonProperty("Actions", jsonArray(
 *                         jsonObject(
 *                             jsonProperty("Identifier", "12345678-1234-1234-1234-123456789012"),
 *                             jsonProperty("Parameters", jsonObject(
 *                                 jsonProperty("Text", "Hello contact flow module")
 *                             )),
 *                             jsonProperty("Transitions", jsonObject(
 *                                 jsonProperty("NextAction", "abcdef-abcd-abcd-abcd-abcdefghijkl"),
 *                                 jsonProperty("Errors", jsonArray(
 *                                 )),
 *                                 jsonProperty("Conditions", jsonArray(
 *                                 ))
 *                             )),
 *                             jsonProperty("Type", "MessageParticipant")
 *                         ),
 *                         jsonObject(
 *                             jsonProperty("Identifier", "abcdef-abcd-abcd-abcd-abcdefghijkl"),
 *                             jsonProperty("Type", "DisconnectParticipant"),
 *                             jsonProperty("Parameters", jsonObject(
 *                             )),
 *                             jsonProperty("Transitions", jsonObject(
 *                             ))
 *                         )
 *                     )),
 *                     jsonProperty("Settings", jsonObject(
 *                         jsonProperty("InputParameters", jsonArray(
 *                         )),
 *                         jsonProperty("OutputParameters", jsonArray(
 *                         )),
 *                         jsonProperty("Transitions", jsonArray(
 *                             jsonObject(
 *                                 jsonProperty("DisplayName", "Success"),
 *                                 jsonProperty("ReferenceName", "Success"),
 *                                 jsonProperty("Description", "")
 *                             ),
 *                             jsonObject(
 *                                 jsonProperty("DisplayName", "Error"),
 *                                 jsonProperty("ReferenceName", "Error"),
 *                                 jsonProperty("Description", "")
 *                             )
 *                         ))
 *                     ))
 *                 )))
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "Example Contact Flow Module"),
 *                 Map.entry("Application", "Example"),
 *                 Map.entry("Method", "Create")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect Contact Flow Modules using the `instance_id` and `contact_flow_module_id` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/contactFlowModule:ContactFlowModule example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * @property content Specifies the content of the Contact Flow Module, provided as a JSON string, written in Amazon Connect Contact Flow Language. If defined, the `filename` argument cannot be used.
 * @property contentHash Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the Contact Flow Module source specified with `filename`.
 * @property description Specifies the description of the Contact Flow Module.
 * @property filename The path to the Contact Flow Module source within the local filesystem. Conflicts with `content`.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property name Specifies the name of the Contact Flow Module.
 * @property tags Tags to apply to the Contact Flow Module. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ContactFlowModuleArgs(
    public val content: Output<String>? = null,
    public val contentHash: Output<String>? = null,
    public val description: Output<String>? = null,
    public val filename: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.ContactFlowModuleArgs> {
    override fun toJava(): com.pulumi.aws.connect.ContactFlowModuleArgs =
        com.pulumi.aws.connect.ContactFlowModuleArgs.builder()
            .content(content?.applyValue({ args0 -> args0 }))
            .contentHash(contentHash?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .filename(filename?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ContactFlowModuleArgs].
 */
@PulumiTagMarker
public class ContactFlowModuleArgsBuilder internal constructor() {
    private var content: Output<String>? = null

    private var contentHash: Output<String>? = null

    private var description: Output<String>? = null

    private var filename: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the content of the Contact Flow Module, provided as a JSON string, written in Amazon Connect Contact Flow Language. If defined, the `filename` argument cannot be used.
     */
    @JvmName("bvyyatalsyelbpcq")
    public suspend fun content(`value`: Output<String>) {
        this.content = value
    }

    /**
     * @param value Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the Contact Flow Module source specified with `filename`.
     */
    @JvmName("lbtunyefwfgilbkh")
    public suspend fun contentHash(`value`: Output<String>) {
        this.contentHash = value
    }

    /**
     * @param value Specifies the description of the Contact Flow Module.
     */
    @JvmName("wjaycjrrbatxfuup")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The path to the Contact Flow Module source within the local filesystem. Conflicts with `content`.
     */
    @JvmName("qlqvnnoipgobudot")
    public suspend fun filename(`value`: Output<String>) {
        this.filename = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("ekknwoqwtcljqxeb")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Specifies the name of the Contact Flow Module.
     */
    @JvmName("xllvpnfhxfsaupeq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Tags to apply to the Contact Flow Module. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wulioroikhywgbnv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the content of the Contact Flow Module, provided as a JSON string, written in Amazon Connect Contact Flow Language. If defined, the `filename` argument cannot be used.
     */
    @JvmName("miqbwvmhmjxqitle")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.content = mapped
    }

    /**
     * @param value Used to trigger updates. Must be set to a base64-encoded SHA256 hash of the Contact Flow Module source specified with `filename`.
     */
    @JvmName("taxgvprvqqvgqxov")
    public suspend fun contentHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentHash = mapped
    }

    /**
     * @param value Specifies the description of the Contact Flow Module.
     */
    @JvmName("qxejkbxevsepmify")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The path to the Contact Flow Module source within the local filesystem. Conflicts with `content`.
     */
    @JvmName("mxrulvlhvigwhfsy")
    public suspend fun filename(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filename = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("daohihjxbfvcuduq")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Specifies the name of the Contact Flow Module.
     */
    @JvmName("virbwymwbsstkmqt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tags to apply to the Contact Flow Module. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dmusfahetpyixrfc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Contact Flow Module. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kdpkctjfxgvswjyw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ContactFlowModuleArgs = ContactFlowModuleArgs(
        content = content,
        contentHash = contentHash,
        description = description,
        filename = filename,
        instanceId = instanceId,
        name = name,
        tags = tags,
    )
}
