@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.HoursOfOperationArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.HoursOfOperationConfigArgs
import com.pulumi.aws.connect.kotlin.inputs.HoursOfOperationConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Hours of Operation resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.HoursOfOperation;
 * import com.pulumi.aws.connect.HoursOfOperationArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigEndTimeArgs;
 * import com.pulumi.aws.connect.inputs.HoursOfOperationConfigStartTimeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new HoursOfOperation("test", HoursOfOperationArgs.builder()
 *             .configs(
 *                 HoursOfOperationConfigArgs.builder()
 *                     .day("MONDAY")
 *                     .endTime(HoursOfOperationConfigEndTimeArgs.builder()
 *                         .hours(23)
 *                         .minutes(8)
 *                         .build())
 *                     .startTime(HoursOfOperationConfigStartTimeArgs.builder()
 *                         .hours(8)
 *                         .minutes(0)
 *                         .build())
 *                     .build(),
 *                 HoursOfOperationConfigArgs.builder()
 *                     .day("TUESDAY")
 *                     .endTime(HoursOfOperationConfigEndTimeArgs.builder()
 *                         .hours(21)
 *                         .minutes(0)
 *                         .build())
 *                     .startTime(HoursOfOperationConfigStartTimeArgs.builder()
 *                         .hours(9)
 *                         .minutes(0)
 *                         .build())
 *                     .build())
 *             .description("Monday office hours")
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .tags(Map.of("Name", "Example Hours of Operation"))
 *             .timeZone("EST")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect Hours of Operations using the `instance_id` and `hours_of_operation_id` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/hoursOfOperation:HoursOfOperation example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * @property configs One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
 * @property description Specifies the description of the Hours of Operation.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property name Specifies the name of the Hours of Operation.
 * @property tags Tags to apply to the Hours of Operation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeZone Specifies the time zone of the Hours of Operation.
 */
public data class HoursOfOperationArgs(
    public val configs: Output<List<HoursOfOperationConfigArgs>>? = null,
    public val description: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.HoursOfOperationArgs> {
    override fun toJava(): com.pulumi.aws.connect.HoursOfOperationArgs =
        com.pulumi.aws.connect.HoursOfOperationArgs.builder()
            .configs(
                configs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HoursOfOperationArgs].
 */
@PulumiTagMarker
public class HoursOfOperationArgsBuilder internal constructor() {
    private var configs: Output<List<HoursOfOperationConfigArgs>>? = null

    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("dapcqdirvdovewwg")
    public suspend fun configs(`value`: Output<List<HoursOfOperationConfigArgs>>) {
        this.configs = value
    }

    @JvmName("uiaeiwsaepnbaqeo")
    public suspend fun configs(vararg values: Output<HoursOfOperationConfigArgs>) {
        this.configs = Output.all(values.asList())
    }

    /**
     * @param values One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("wqgteyxrrjpquikf")
    public suspend fun configs(values: List<Output<HoursOfOperationConfigArgs>>) {
        this.configs = Output.all(values)
    }

    /**
     * @param value Specifies the description of the Hours of Operation.
     */
    @JvmName("akwaamcwebwxetms")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("xmpbbhmkhrtqegje")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Specifies the name of the Hours of Operation.
     */
    @JvmName("qggfvfcrayxihqxd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Tags to apply to the Hours of Operation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pynfgwqkcqinnbke")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the time zone of the Hours of Operation.
     */
    @JvmName("pdjpngrjqhfptkit")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("rqnqimheeycohhwe")
    public suspend fun configs(`value`: List<HoursOfOperationConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configs = mapped
    }

    /**
     * @param argument One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("wvaekpoduoadqyst")
    public suspend fun configs(argument: List<suspend HoursOfOperationConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HoursOfOperationConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configs = mapped
    }

    /**
     * @param argument One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("jlguhkhodrpwomic")
    public suspend fun configs(
        vararg
        argument: suspend HoursOfOperationConfigArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            HoursOfOperationConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configs = mapped
    }

    /**
     * @param argument One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("wgfjdphphtpjnivd")
    public suspend fun configs(argument: suspend HoursOfOperationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HoursOfOperationConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.configs = mapped
    }

    /**
     * @param values One or more config blocks which define the configuration information for the hours of operation: day, start time, and end time . Config blocks are documented below.
     */
    @JvmName("ptbxuqjxnjtxswgu")
    public suspend fun configs(vararg values: HoursOfOperationConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configs = mapped
    }

    /**
     * @param value Specifies the description of the Hours of Operation.
     */
    @JvmName("xsjxwjgrqjtjagls")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("pdhslpbwbplvrfby")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Specifies the name of the Hours of Operation.
     */
    @JvmName("ldwwastrsrveryys")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tags to apply to the Hours of Operation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("grnbjkocgwioqnuc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Hours of Operation. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ihafxjreliiojasr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the time zone of the Hours of Operation.
     */
    @JvmName("uqytwvyeaaxbumnd")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): HoursOfOperationArgs = HoursOfOperationArgs(
        configs = configs,
        description = description,
        instanceId = instanceId,
        name = name,
        tags = tags,
        timeZone = timeZone,
    )
}
