@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.aws.connect.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect instance resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * !> **WARN:** Amazon Connect enforces a limit of [100 combined instance creation and deletions every 30 days](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits).  For example, if you create 80 instances and delete 20 of them, you must wait 30 days to create or delete another instance.  Use care when creating or deleting instances.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Instance;
 * import com.pulumi.aws.connect.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .identityManagementType("CONNECT_MANAGED")
 *             .inboundCallsEnabled(true)
 *             .instanceAlias("friendly-name-connect")
 *             .outboundCallsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ### With Existing Active Directory
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Instance;
 * import com.pulumi.aws.connect.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .directoryId(aws_directory_service_directory.test().id())
 *             .identityManagementType("EXISTING_DIRECTORY")
 *             .inboundCallsEnabled(true)
 *             .instanceAlias("friendly-name-connect")
 *             .outboundCallsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ### With SAML
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Instance;
 * import com.pulumi.aws.connect.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .identityManagementType("SAML")
 *             .inboundCallsEnabled(true)
 *             .instanceAlias("friendly-name-connect")
 *             .outboundCallsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Connect instances using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:connect/instance:Instance example f1288a1f-6193-445a-b47e-af739b2
 * ```
 *
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.aws.connect.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Amazon Resource Name (ARN) of the instance.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies whether auto resolve best voices is enabled. Defaults to `true`.
     */
    public val autoResolveBestVoicesEnabled: Output<Boolean>?
        get() = javaResource.autoResolveBestVoicesEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether contact flow logs are enabled. Defaults to `false`.
     */
    public val contactFlowLogsEnabled: Output<Boolean>?
        get() = javaResource.contactFlowLogsEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether contact lens is enabled. Defaults to `true`.
     */
    public val contactLensEnabled: Output<Boolean>?
        get() = javaResource.contactLensEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * When the instance was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
     */
    public val directoryId: Output<String>?
        get() = javaResource.directoryId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
     */
    public val earlyMediaEnabled: Output<Boolean>?
        get() = javaResource.earlyMediaEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
     */
    public val identityManagementType: Output<String>
        get() = javaResource.identityManagementType().applyValue({ args0 -> args0 })

    /**
     * Specifies whether inbound calls are enabled.
     */
    public val inboundCallsEnabled: Output<Boolean>
        get() = javaResource.inboundCallsEnabled().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the instance. Required if `directory_id` not specified.
     */
    public val instanceAlias: Output<String>?
        get() = javaResource.instanceAlias().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
     */
    public val multiPartyConferenceEnabled: Output<Boolean>?
        get() = javaResource.multiPartyConferenceEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether outbound calls are enabled.
     * <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
     */
    public val outboundCallsEnabled: Output<Boolean>
        get() = javaResource.outboundCallsEnabled().applyValue({ args0 -> args0 })

    /**
     * The service role of the instance.
     */
    public val serviceRole: Output<String>
        get() = javaResource.serviceRole().applyValue({ args0 -> args0 })

    /**
     * The state of the instance.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.aws.connect.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit):
    Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
