@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect instance resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * !> **WARN:** Amazon Connect enforces a limit of [100 combined instance creation and deletions every 30 days](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits).  For example, if you create 80 instances and delete 20 of them, you must wait 30 days to create or delete another instance.  Use care when creating or deleting instances.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Instance;
 * import com.pulumi.aws.connect.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .identityManagementType("CONNECT_MANAGED")
 *             .inboundCallsEnabled(true)
 *             .instanceAlias("friendly-name-connect")
 *             .outboundCallsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ### With Existing Active Directory
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Instance;
 * import com.pulumi.aws.connect.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .directoryId(aws_directory_service_directory.test().id())
 *             .identityManagementType("EXISTING_DIRECTORY")
 *             .inboundCallsEnabled(true)
 *             .instanceAlias("friendly-name-connect")
 *             .outboundCallsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ### With SAML
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.Instance;
 * import com.pulumi.aws.connect.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Instance("test", InstanceArgs.builder()
 *             .identityManagementType("SAML")
 *             .inboundCallsEnabled(true)
 *             .instanceAlias("friendly-name-connect")
 *             .outboundCallsEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Connect instances using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:connect/instance:Instance example f1288a1f-6193-445a-b47e-af739b2
 * ```
 * @property autoResolveBestVoicesEnabled Specifies whether auto resolve best voices is enabled. Defaults to `true`.
 * @property contactFlowLogsEnabled Specifies whether contact flow logs are enabled. Defaults to `false`.
 * @property contactLensEnabled Specifies whether contact lens is enabled. Defaults to `true`.
 * @property directoryId The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
 * @property earlyMediaEnabled Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
 * @property identityManagementType Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
 * @property inboundCallsEnabled Specifies whether inbound calls are enabled.
 * @property instanceAlias Specifies the name of the instance. Required if `directory_id` not specified.
 * @property multiPartyConferenceEnabled Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
 * @property outboundCallsEnabled Specifies whether outbound calls are enabled.
 * <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
 */
public data class InstanceArgs(
    public val autoResolveBestVoicesEnabled: Output<Boolean>? = null,
    public val contactFlowLogsEnabled: Output<Boolean>? = null,
    public val contactLensEnabled: Output<Boolean>? = null,
    public val directoryId: Output<String>? = null,
    public val earlyMediaEnabled: Output<Boolean>? = null,
    public val identityManagementType: Output<String>? = null,
    public val inboundCallsEnabled: Output<Boolean>? = null,
    public val instanceAlias: Output<String>? = null,
    public val multiPartyConferenceEnabled: Output<Boolean>? = null,
    public val outboundCallsEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.InstanceArgs> {
    override fun toJava(): com.pulumi.aws.connect.InstanceArgs =
        com.pulumi.aws.connect.InstanceArgs.builder()
            .autoResolveBestVoicesEnabled(autoResolveBestVoicesEnabled?.applyValue({ args0 -> args0 }))
            .contactFlowLogsEnabled(contactFlowLogsEnabled?.applyValue({ args0 -> args0 }))
            .contactLensEnabled(contactLensEnabled?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .earlyMediaEnabled(earlyMediaEnabled?.applyValue({ args0 -> args0 }))
            .identityManagementType(identityManagementType?.applyValue({ args0 -> args0 }))
            .inboundCallsEnabled(inboundCallsEnabled?.applyValue({ args0 -> args0 }))
            .instanceAlias(instanceAlias?.applyValue({ args0 -> args0 }))
            .multiPartyConferenceEnabled(multiPartyConferenceEnabled?.applyValue({ args0 -> args0 }))
            .outboundCallsEnabled(outboundCallsEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var autoResolveBestVoicesEnabled: Output<Boolean>? = null

    private var contactFlowLogsEnabled: Output<Boolean>? = null

    private var contactLensEnabled: Output<Boolean>? = null

    private var directoryId: Output<String>? = null

    private var earlyMediaEnabled: Output<Boolean>? = null

    private var identityManagementType: Output<String>? = null

    private var inboundCallsEnabled: Output<Boolean>? = null

    private var instanceAlias: Output<String>? = null

    private var multiPartyConferenceEnabled: Output<Boolean>? = null

    private var outboundCallsEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies whether auto resolve best voices is enabled. Defaults to `true`.
     */
    @JvmName("fpioqlvjgtetltsb")
    public suspend fun autoResolveBestVoicesEnabled(`value`: Output<Boolean>) {
        this.autoResolveBestVoicesEnabled = value
    }

    /**
     * @param value Specifies whether contact flow logs are enabled. Defaults to `false`.
     */
    @JvmName("jqhgxogucwscnasb")
    public suspend fun contactFlowLogsEnabled(`value`: Output<Boolean>) {
        this.contactFlowLogsEnabled = value
    }

    /**
     * @param value Specifies whether contact lens is enabled. Defaults to `true`.
     */
    @JvmName("pvtdallhuppetnib")
    public suspend fun contactLensEnabled(`value`: Output<Boolean>) {
        this.contactLensEnabled = value
    }

    /**
     * @param value The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
     */
    @JvmName("ayixfdakkyeqdxor")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
     */
    @JvmName("temoeqxffrvvpoqp")
    public suspend fun earlyMediaEnabled(`value`: Output<Boolean>) {
        this.earlyMediaEnabled = value
    }

    /**
     * @param value Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
     */
    @JvmName("boafkucsrrkklbyp")
    public suspend fun identityManagementType(`value`: Output<String>) {
        this.identityManagementType = value
    }

    /**
     * @param value Specifies whether inbound calls are enabled.
     */
    @JvmName("pwgwjhvfdeplughv")
    public suspend fun inboundCallsEnabled(`value`: Output<Boolean>) {
        this.inboundCallsEnabled = value
    }

    /**
     * @param value Specifies the name of the instance. Required if `directory_id` not specified.
     */
    @JvmName("bjufkilblwpyopbc")
    public suspend fun instanceAlias(`value`: Output<String>) {
        this.instanceAlias = value
    }

    /**
     * @param value Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
     */
    @JvmName("nlpkjowtkioinbyh")
    public suspend fun multiPartyConferenceEnabled(`value`: Output<Boolean>) {
        this.multiPartyConferenceEnabled = value
    }

    /**
     * @param value Specifies whether outbound calls are enabled.
     * <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
     */
    @JvmName("mugxesriprjjauic")
    public suspend fun outboundCallsEnabled(`value`: Output<Boolean>) {
        this.outboundCallsEnabled = value
    }

    /**
     * @param value Specifies whether auto resolve best voices is enabled. Defaults to `true`.
     */
    @JvmName("svxseusfqajidqwf")
    public suspend fun autoResolveBestVoicesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoResolveBestVoicesEnabled = mapped
    }

    /**
     * @param value Specifies whether contact flow logs are enabled. Defaults to `false`.
     */
    @JvmName("awdcuycjmiruighm")
    public suspend fun contactFlowLogsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactFlowLogsEnabled = mapped
    }

    /**
     * @param value Specifies whether contact lens is enabled. Defaults to `true`.
     */
    @JvmName("qhrdciieejxqlenu")
    public suspend fun contactLensEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contactLensEnabled = mapped
    }

    /**
     * @param value The identifier for the directory if identity_management_type is `EXISTING_DIRECTORY`.
     */
    @JvmName("pxfcblynlvhtmwnb")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value Specifies whether early media for outbound calls is enabled . Defaults to `true` if outbound calls is enabled.
     */
    @JvmName("hchtodfjogdimgrr")
    public suspend fun earlyMediaEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.earlyMediaEnabled = mapped
    }

    /**
     * @param value Specifies the identity management type attached to the instance. Allowed Values are: `SAML`, `CONNECT_MANAGED`, `EXISTING_DIRECTORY`.
     */
    @JvmName("oiqeaguwmkvhjejh")
    public suspend fun identityManagementType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityManagementType = mapped
    }

    /**
     * @param value Specifies whether inbound calls are enabled.
     */
    @JvmName("entgnpramjnjsnhe")
    public suspend fun inboundCallsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inboundCallsEnabled = mapped
    }

    /**
     * @param value Specifies the name of the instance. Required if `directory_id` not specified.
     */
    @JvmName("ctigkdqtdcgepths")
    public suspend fun instanceAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceAlias = mapped
    }

    /**
     * @param value Specifies whether multi-party calls/conference is enabled. Defaults to `false`.
     */
    @JvmName("csypeqjxbnqoqjgt")
    public suspend fun multiPartyConferenceEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiPartyConferenceEnabled = mapped
    }

    /**
     * @param value Specifies whether outbound calls are enabled.
     * <!-- * `use_custom_tts_voices` - (Optional) Whether use custom tts voices is enabled. Defaults to `false` -->
     */
    @JvmName("vojbcockmvtgnkrp")
    public suspend fun outboundCallsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundCallsEnabled = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        autoResolveBestVoicesEnabled = autoResolveBestVoicesEnabled,
        contactFlowLogsEnabled = contactFlowLogsEnabled,
        contactLensEnabled = contactLensEnabled,
        directoryId = directoryId,
        earlyMediaEnabled = earlyMediaEnabled,
        identityManagementType = identityManagementType,
        inboundCallsEnabled = inboundCallsEnabled,
        instanceAlias = instanceAlias,
        multiPartyConferenceEnabled = multiPartyConferenceEnabled,
        outboundCallsEnabled = outboundCallsEnabled,
    )
}
