@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.InstanceStorageConfigStorageConfig
import com.pulumi.aws.connect.kotlin.outputs.InstanceStorageConfigStorageConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InstanceStorageConfig].
 */
@PulumiTagMarker
public class InstanceStorageConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceStorageConfigArgs = InstanceStorageConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceStorageConfigArgsBuilder.() -> Unit) {
        val builder = InstanceStorageConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InstanceStorageConfig {
        val builtJavaResource = com.pulumi.aws.connect.InstanceStorageConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstanceStorageConfig(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect Instance Storage Config resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Storage Config Kinesis Firehose Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .resourceType("CONTACT_TRACE_RECORDS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisFirehoseConfig(InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs.builder()
 *                     .firehoseArn(aws_kinesis_firehose_delivery_stream.example().arn())
 *                     .build())
 *                 .storageType("KINESIS_FIREHOSE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Storage Config Kinesis Stream Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .resourceType("CONTACT_TRACE_RECORDS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisStreamConfig(InstanceStorageConfigStorageConfigKinesisStreamConfigArgs.builder()
 *                     .streamArn(aws_kinesis_stream.example().arn())
 *                     .build())
 *                 .storageType("KINESIS_STREAM")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Storage Config Kinesis Video Stream Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .resourceType("MEDIA_STREAMS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisVideoStreamConfig(InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs.builder()
 *                     .prefix("example")
 *                     .retentionPeriodHours(3)
 *                     .encryptionConfig(InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs.builder()
 *                         .encryptionType("KMS")
 *                         .keyId(aws_kms_key.example().arn())
 *                         .build())
 *                     .build())
 *                 .storageType("KINESIS_VIDEO_STREAM")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Storage Config S3 Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .resourceType("CHAT_TRANSCRIPTS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .s3Config(InstanceStorageConfigStorageConfigS3ConfigArgs.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .bucketPrefix("example")
 *                     .build())
 *                 .storageType("S3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Storage Config S3 Config with Encryption Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .resourceType("CHAT_TRANSCRIPTS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .s3Config(InstanceStorageConfigStorageConfigS3ConfigArgs.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .bucketPrefix("example")
 *                     .encryptionConfig(InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs.builder()
 *                         .encryptionType("KMS")
 *                         .keyId(aws_kms_key.example().arn())
 *                         .build())
 *                     .build())
 *                 .storageType("S3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect Instance Storage Configs using the `instance_id`, `association_id`, and `resource_type` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/instanceStorageConfig:InstanceStorageConfig example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5:CHAT_TRANSCRIPTS
 * ```
 *
 */
public class InstanceStorageConfig internal constructor(
    override val javaResource: com.pulumi.aws.connect.InstanceStorageConfig,
) : KotlinCustomResource(javaResource, InstanceStorageConfigMapper) {
    /**
     * The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.
     */
    public val associationId: Output<String>
        get() = javaResource.associationId().applyValue({ args0 -> args0 })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` | `SCREEN_RECORDINGS`.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * Specifies the storage configuration options for the Connect Instance. Documented below.
     */
    public val storageConfig: Output<InstanceStorageConfigStorageConfig>
        get() = javaResource.storageConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object InstanceStorageConfigMapper : ResourceMapper<InstanceStorageConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.InstanceStorageConfig::class == javaResource::class

    override fun map(javaResource: Resource): InstanceStorageConfig =
        InstanceStorageConfig(javaResource as com.pulumi.aws.connect.InstanceStorageConfig)
}

/**
 * @see [InstanceStorageConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceStorageConfig].
 */
public suspend fun instanceStorageConfig(
    name: String,
    block: suspend InstanceStorageConfigResourceBuilder.() -> Unit,
): InstanceStorageConfig {
    val builder = InstanceStorageConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceStorageConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceStorageConfig(name: String): InstanceStorageConfig {
    val builder = InstanceStorageConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
