@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.InstanceStorageConfigArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.InstanceStorageConfigStorageConfigArgs
import com.pulumi.aws.connect.kotlin.inputs.InstanceStorageConfigStorageConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Instance Storage Config resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Storage Config Kinesis Firehose Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .resourceType("CONTACT_TRACE_RECORDS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisFirehoseConfig(InstanceStorageConfigStorageConfigKinesisFirehoseConfigArgs.builder()
 *                     .firehoseArn(aws_kinesis_firehose_delivery_stream.example().arn())
 *                     .build())
 *                 .storageType("KINESIS_FIREHOSE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Storage Config Kinesis Stream Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisStreamConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .resourceType("CONTACT_TRACE_RECORDS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisStreamConfig(InstanceStorageConfigStorageConfigKinesisStreamConfigArgs.builder()
 *                     .streamArn(aws_kinesis_stream.example().arn())
 *                     .build())
 *                 .storageType("KINESIS_STREAM")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Storage Config Kinesis Video Stream Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .resourceType("MEDIA_STREAMS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .kinesisVideoStreamConfig(InstanceStorageConfigStorageConfigKinesisVideoStreamConfigArgs.builder()
 *                     .prefix("example")
 *                     .retentionPeriodHours(3)
 *                     .encryptionConfig(InstanceStorageConfigStorageConfigKinesisVideoStreamConfigEncryptionConfigArgs.builder()
 *                         .encryptionType("KMS")
 *                         .keyId(aws_kms_key.example().arn())
 *                         .build())
 *                     .build())
 *                 .storageType("KINESIS_VIDEO_STREAM")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Storage Config S3 Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .resourceType("CHAT_TRANSCRIPTS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .s3Config(InstanceStorageConfigStorageConfigS3ConfigArgs.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .bucketPrefix("example")
 *                     .build())
 *                 .storageType("S3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Storage Config S3 Config with Encryption Config
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.InstanceStorageConfig;
 * import com.pulumi.aws.connect.InstanceStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigArgs;
 * import com.pulumi.aws.connect.inputs.InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InstanceStorageConfig("example", InstanceStorageConfigArgs.builder()
 *             .instanceId(aws_connect_instance.example().id())
 *             .resourceType("CHAT_TRANSCRIPTS")
 *             .storageConfig(InstanceStorageConfigStorageConfigArgs.builder()
 *                 .s3Config(InstanceStorageConfigStorageConfigS3ConfigArgs.builder()
 *                     .bucketName(aws_s3_bucket.example().id())
 *                     .bucketPrefix("example")
 *                     .encryptionConfig(InstanceStorageConfigStorageConfigS3ConfigEncryptionConfigArgs.builder()
 *                         .encryptionType("KMS")
 *                         .keyId(aws_kms_key.example().arn())
 *                         .build())
 *                     .build())
 *                 .storageType("S3")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect Instance Storage Configs using the `instance_id`, `association_id`, and `resource_type` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/instanceStorageConfig:InstanceStorageConfig example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5:CHAT_TRANSCRIPTS
 * ```
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property resourceType A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` | `SCREEN_RECORDINGS`.
 * @property storageConfig Specifies the storage configuration options for the Connect Instance. Documented below.
 */
public data class InstanceStorageConfigArgs(
    public val instanceId: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val storageConfig: Output<InstanceStorageConfigStorageConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.InstanceStorageConfigArgs> {
    override fun toJava(): com.pulumi.aws.connect.InstanceStorageConfigArgs =
        com.pulumi.aws.connect.InstanceStorageConfigArgs.builder()
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .storageConfig(storageConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InstanceStorageConfigArgs].
 */
@PulumiTagMarker
public class InstanceStorageConfigArgsBuilder internal constructor() {
    private var instanceId: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var storageConfig: Output<InstanceStorageConfigStorageConfigArgs>? = null

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("scsqfacwsxifpeun")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` | `SCREEN_RECORDINGS`.
     */
    @JvmName("lyjidyrsrsypduqv")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Specifies the storage configuration options for the Connect Instance. Documented below.
     */
    @JvmName("hobqlxkvkcwynqvt")
    public suspend fun storageConfig(`value`: Output<InstanceStorageConfigStorageConfigArgs>) {
        this.storageConfig = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("qldsoqqvqqabrxpk")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value A valid resource type. Valid Values: `AGENT_EVENTS` | `ATTACHMENTS` | `CALL_RECORDINGS` | `CHAT_TRANSCRIPTS` | `CONTACT_EVALUATIONS` | `CONTACT_TRACE_RECORDS` | `MEDIA_STREAMS` | `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` | `SCHEDULED_REPORTS` | `SCREEN_RECORDINGS`.
     */
    @JvmName("snajleqiunhxvfwp")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Specifies the storage configuration options for the Connect Instance. Documented below.
     */
    @JvmName("jxyvvhdclhpnbttr")
    public suspend fun storageConfig(`value`: InstanceStorageConfigStorageConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageConfig = mapped
    }

    /**
     * @param argument Specifies the storage configuration options for the Connect Instance. Documented below.
     */
    @JvmName("xsjotbrfjxwxitpg")
    public suspend
    fun storageConfig(argument: suspend InstanceStorageConfigStorageConfigArgsBuilder.() -> Unit) {
        val toBeMapped = InstanceStorageConfigStorageConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.storageConfig = mapped
    }

    internal fun build(): InstanceStorageConfigArgs = InstanceStorageConfigArgs(
        instanceId = instanceId,
        resourceType = resourceType,
        storageConfig = storageConfig,
    )
}
