@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.LambdaFunctionAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Lambda Function Association. For more information see
 * [Amazon Connect: Getting Started](https://docs&#46;aws&#46;amazon&#46;com/connect/latest/adminguide/amazon-connect-get-started&#46;html) and [Invoke AWS Lambda functions](https://docs.aws.amazon.com/connect/latest/adminguide/connect-lambda-functions.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.LambdaFunctionAssociation;
 * import com.pulumi.aws.connect.LambdaFunctionAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new LambdaFunctionAssociation("example", LambdaFunctionAssociationArgs.builder()
 *             .functionArn(aws_lambda_function.example().arn())
 *             .instanceId(aws_connect_instance.example().id())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_connect_lambda_function_association` using the `instance_id` and `function_arn` separated by a comma (`,`). For example:
 * ```sh
 *  $ pulumi import aws:connect/lambdaFunctionAssociation:LambdaFunctionAssociation example aaaaaaaa-bbbb-cccc-dddd-111111111111,arn:aws:lambda:us-west-2:123456789123:function:example
 * ```
 * @property functionArn Amazon Resource Name (ARN) of the Lambda Function, omitting any version or alias qualifier.
 * @property instanceId The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
 */
public data class LambdaFunctionAssociationArgs(
    public val functionArn: Output<String>? = null,
    public val instanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.LambdaFunctionAssociationArgs> {
    override fun toJava(): com.pulumi.aws.connect.LambdaFunctionAssociationArgs =
        com.pulumi.aws.connect.LambdaFunctionAssociationArgs.builder()
            .functionArn(functionArn?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LambdaFunctionAssociationArgs].
 */
@PulumiTagMarker
public class LambdaFunctionAssociationArgsBuilder internal constructor() {
    private var functionArn: Output<String>? = null

    private var instanceId: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the Lambda Function, omitting any version or alias qualifier.
     */
    @JvmName("veoyexwlgweosjif")
    public suspend fun functionArn(`value`: Output<String>) {
        this.functionArn = value
    }

    /**
     * @param value The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    @JvmName("yvdyqlokroduewxa")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Lambda Function, omitting any version or alias qualifier.
     */
    @JvmName("anqbfwwmwtircuom")
    public suspend fun functionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionArn = mapped
    }

    /**
     * @param value The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    @JvmName("itqfvwqrsameldik")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    internal fun build(): LambdaFunctionAssociationArgs = LambdaFunctionAssociationArgs(
        functionArn = functionArn,
        instanceId = instanceId,
    )
}
