@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.PhoneNumberStatus
import com.pulumi.aws.connect.kotlin.outputs.PhoneNumberStatus.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [PhoneNumber].
 */
@PulumiTagMarker
public class PhoneNumberResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PhoneNumberArgs = PhoneNumberArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PhoneNumberArgsBuilder.() -> Unit) {
        val builder = PhoneNumberArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PhoneNumber {
        val builtJavaResource = com.pulumi.aws.connect.PhoneNumber(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return PhoneNumber(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect Phone Number resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ### Basic
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.PhoneNumber;
 * import com.pulumi.aws.connect.PhoneNumberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PhoneNumber("example", PhoneNumberArgs.builder()
 *             .targetArn(aws_connect_instance.example().arn())
 *             .countryCode("US")
 *             .type("DID")
 *             .tags(Map.of("hello", "world"))
 *             .build());
 *     }
 * }
 * ```
 * ### Description
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.PhoneNumber;
 * import com.pulumi.aws.connect.PhoneNumberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PhoneNumber("example", PhoneNumberArgs.builder()
 *             .targetArn(aws_connect_instance.example().arn())
 *             .countryCode("US")
 *             .type("DID")
 *             .description("example description")
 *             .build());
 *     }
 * }
 * ```
 * ### Prefix to filter phone numbers
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.PhoneNumber;
 * import com.pulumi.aws.connect.PhoneNumberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PhoneNumber("example", PhoneNumberArgs.builder()
 *             .targetArn(aws_connect_instance.example().arn())
 *             .countryCode("US")
 *             .type("DID")
 *             .prefix("+18005")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect Phone Numbers using its `id`. For example:
 * ```sh
 *  $ pulumi import aws:connect/phoneNumber:PhoneNumber example 12345678-abcd-1234-efgh-9876543210ab
 * ```
 *
 */
public class PhoneNumber internal constructor(
    override val javaResource: com.pulumi.aws.connect.PhoneNumber,
) : KotlinCustomResource(javaResource, PhoneNumberMapper) {
    /**
     * The ARN of the phone number.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ISO country code. For a list of Valid values, refer to [PhoneNumberCountryCode](https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html#connect-SearchAvailablePhoneNumbers-request-PhoneNumberCountryCode).
     */
    public val countryCode: Output<String>
        get() = javaResource.countryCode().applyValue({ args0 -> args0 })

    /**
     * The description of the phone number.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The phone number. Phone numbers are formatted `[+] [country code] [subscriber number including area code]`.
     */
    public val phoneNumber: Output<String>
        get() = javaResource.phoneNumber().applyValue({ args0 -> args0 })

    /**
     * The prefix of the phone number that is used to filter available phone numbers. If provided, it must contain `+` as part of the country code. Do not specify this argument when importing the resource.
     */
    public val prefix: Output<String>?
        get() = javaResource.prefix().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the phone number. Valid Values: `CLAIMED` | `IN_PROGRESS` | `FAILED`.
     */
    public val statuses: Output<List<PhoneNumberStatus>>
        get() = javaResource.statuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Tags to apply to the Phone Number. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Amazon Resource Name (ARN) for Amazon Connect instances that phone numbers are claimed to.
     */
    public val targetArn: Output<String>
        get() = javaResource.targetArn().applyValue({ args0 -> args0 })

    /**
     * The type of phone number. Valid Values: `TOLL_FREE` | `DID`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PhoneNumberMapper : ResourceMapper<PhoneNumber> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.PhoneNumber::class == javaResource::class

    override fun map(javaResource: Resource): PhoneNumber = PhoneNumber(
        javaResource as
            com.pulumi.aws.connect.PhoneNumber,
    )
}

/**
 * @see [PhoneNumber].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PhoneNumber].
 */
public suspend fun phoneNumber(name: String, block: suspend PhoneNumberResourceBuilder.() -> Unit):
    PhoneNumber {
    val builder = PhoneNumberResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PhoneNumber].
 * @param name The _unique_ name of the resulting resource.
 */
public fun phoneNumber(name: String): PhoneNumber {
    val builder = PhoneNumberResourceBuilder()
    builder.name(name)
    return builder.build()
}
