@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.kotlin.outputs.QuickConnectQuickConnectConfig
import com.pulumi.aws.connect.kotlin.outputs.QuickConnectQuickConnectConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [QuickConnect].
 */
@PulumiTagMarker
public class QuickConnectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QuickConnectArgs = QuickConnectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QuickConnectArgsBuilder.() -> Unit) {
        val builder = QuickConnectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): QuickConnect {
        val builtJavaResource = com.pulumi.aws.connect.QuickConnect(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return QuickConnect(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect Quick Connect resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.QuickConnect;
 * import com.pulumi.aws.connect.QuickConnectArgs;
 * import com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new QuickConnect("test", QuickConnectArgs.builder()
 *             .description("quick connect phone number")
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .quickConnectConfig(QuickConnectQuickConnectConfigArgs.builder()
 *                 .phoneConfigs(QuickConnectQuickConnectConfigPhoneConfigArgs.builder()
 *                     .phoneNumber("+12345678912")
 *                     .build())
 *                 .quickConnectType("PHONE_NUMBER")
 *                 .build())
 *             .tags(Map.of("Name", "Example Quick Connect"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect Quick Connects using the `instance_id` and `quick_connect_id` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/quickConnect:QuickConnect example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 *
 */
public class QuickConnect internal constructor(
    override val javaResource: com.pulumi.aws.connect.QuickConnect,
) : KotlinCustomResource(javaResource, QuickConnectMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Quick Connect.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies the description of the Quick Connect.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the Quick Connect.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A block that defines the configuration information for the Quick Connect: `quick_connect_type` and one of `phone_config`, `queue_config`, `user_config` . The Quick Connect Config block is documented below.
     */
    public val quickConnectConfig: Output<QuickConnectQuickConnectConfig>
        get() = javaResource.quickConnectConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The identifier for the Quick Connect.
     */
    public val quickConnectId: Output<String>
        get() = javaResource.quickConnectId().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the Quick Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object QuickConnectMapper : ResourceMapper<QuickConnect> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.QuickConnect::class == javaResource::class

    override fun map(javaResource: Resource): QuickConnect = QuickConnect(
        javaResource as
            com.pulumi.aws.connect.QuickConnect,
    )
}

/**
 * @see [QuickConnect].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [QuickConnect].
 */
public suspend fun quickConnect(
    name: String,
    block: suspend QuickConnectResourceBuilder.() -> Unit,
): QuickConnect {
    val builder = QuickConnectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [QuickConnect].
 * @param name The _unique_ name of the resulting resource.
 */
public fun quickConnect(name: String): QuickConnect {
    val builder = QuickConnectResourceBuilder()
    builder.name(name)
    return builder.build()
}
