@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.QuickConnectArgs.builder
import com.pulumi.aws.connect.kotlin.inputs.QuickConnectQuickConnectConfigArgs
import com.pulumi.aws.connect.kotlin.inputs.QuickConnectQuickConnectConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Quick Connect resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.QuickConnect;
 * import com.pulumi.aws.connect.QuickConnectArgs;
 * import com.pulumi.aws.connect.inputs.QuickConnectQuickConnectConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new QuickConnect("test", QuickConnectArgs.builder()
 *             .description("quick connect phone number")
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .quickConnectConfig(QuickConnectQuickConnectConfigArgs.builder()
 *                 .phoneConfigs(QuickConnectQuickConnectConfigPhoneConfigArgs.builder()
 *                     .phoneNumber("+12345678912")
 *                     .build())
 *                 .quickConnectType("PHONE_NUMBER")
 *                 .build())
 *             .tags(Map.of("Name", "Example Quick Connect"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect Quick Connects using the `instance_id` and `quick_connect_id` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/quickConnect:QuickConnect example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * @property description Specifies the description of the Quick Connect.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property name Specifies the name of the Quick Connect.
 * @property quickConnectConfig A block that defines the configuration information for the Quick Connect: `quick_connect_type` and one of `phone_config`, `queue_config`, `user_config` . The Quick Connect Config block is documented below.
 * @property tags Tags to apply to the Quick Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class QuickConnectArgs(
    public val description: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val quickConnectConfig: Output<QuickConnectQuickConnectConfigArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.QuickConnectArgs> {
    override fun toJava(): com.pulumi.aws.connect.QuickConnectArgs =
        com.pulumi.aws.connect.QuickConnectArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .quickConnectConfig(
                quickConnectConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [QuickConnectArgs].
 */
@PulumiTagMarker
public class QuickConnectArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    private var quickConnectConfig: Output<QuickConnectQuickConnectConfigArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the description of the Quick Connect.
     */
    @JvmName("dbcjuylgldegfqcx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("vefxgsrlgtgqfepm")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Specifies the name of the Quick Connect.
     */
    @JvmName("vgffdpeqenkneqcr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A block that defines the configuration information for the Quick Connect: `quick_connect_type` and one of `phone_config`, `queue_config`, `user_config` . The Quick Connect Config block is documented below.
     */
    @JvmName("igmsyypvbsanaadd")
    public suspend fun quickConnectConfig(`value`: Output<QuickConnectQuickConnectConfigArgs>) {
        this.quickConnectConfig = value
    }

    /**
     * @param value Tags to apply to the Quick Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lwewtjqnbpfrhjnb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the description of the Quick Connect.
     */
    @JvmName("kftguwkhwkonccqq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("kdpidpdcbjvevfou")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Specifies the name of the Quick Connect.
     */
    @JvmName("ydfrkastsmawppvk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A block that defines the configuration information for the Quick Connect: `quick_connect_type` and one of `phone_config`, `queue_config`, `user_config` . The Quick Connect Config block is documented below.
     */
    @JvmName("rgcawgjpcdyqsaqe")
    public suspend fun quickConnectConfig(`value`: QuickConnectQuickConnectConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.quickConnectConfig = mapped
    }

    /**
     * @param argument A block that defines the configuration information for the Quick Connect: `quick_connect_type` and one of `phone_config`, `queue_config`, `user_config` . The Quick Connect Config block is documented below.
     */
    @JvmName("cdivtargnipxatrk")
    public suspend
    fun quickConnectConfig(argument: suspend QuickConnectQuickConnectConfigArgsBuilder.() -> Unit) {
        val toBeMapped = QuickConnectQuickConnectConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.quickConnectConfig = mapped
    }

    /**
     * @param value Tags to apply to the Quick Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bbhysmjbgswqwedy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Quick Connect. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hxoiflwbedrvxdnd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): QuickConnectArgs = QuickConnectArgs(
        description = description,
        instanceId = instanceId,
        name = name,
        quickConnectConfig = quickConnectConfig,
        tags = tags,
    )
}
