@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [SecurityProfile].
 */
@PulumiTagMarker
public class SecurityProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityProfileArgs = SecurityProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityProfileArgsBuilder.() -> Unit) {
        val builder = SecurityProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecurityProfile {
        val builtJavaResource = com.pulumi.aws.connect.SecurityProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SecurityProfile(builtJavaResource)
    }
}

/**
 * Provides an Amazon Connect Security Profile resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.SecurityProfile;
 * import com.pulumi.aws.connect.SecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityProfile("example", SecurityProfileArgs.builder()
 *             .description("example description")
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .permissions(
 *                 "BasicAgentAccess",
 *                 "OutboundCallAccess")
 *             .tags(Map.of("Name", "Example Security Profile"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect Security Profiles using the `instance_id` and `security_profile_id` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/securityProfile:SecurityProfile example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 *
 */
public class SecurityProfile internal constructor(
    override val javaResource: com.pulumi.aws.connect.SecurityProfile,
) : KotlinCustomResource(javaResource, SecurityProfileMapper) {
    /**
     * The Amazon Resource Name (ARN) of the Security Profile.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies the description of the Security Profile.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the identifier of the hosting Amazon Connect Instance.
     */
    public val instanceId: Output<String>
        get() = javaResource.instanceId().applyValue({ args0 -> args0 })

    /**
     * Specifies the name of the Security Profile.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The organization resource identifier for the security profile.
     */
    public val organizationResourceId: Output<String>
        get() = javaResource.organizationResourceId().applyValue({ args0 -> args0 })

    /**
     * Specifies a list of permissions assigned to the security profile.
     */
    public val permissions: Output<List<String>>?
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The identifier for the Security Profile.
     */
    public val securityProfileId: Output<String>
        get() = javaResource.securityProfileId().applyValue({ args0 -> args0 })

    /**
     * Tags to apply to the Security Profile. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object SecurityProfileMapper : ResourceMapper<SecurityProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.connect.SecurityProfile::class == javaResource::class

    override fun map(javaResource: Resource): SecurityProfile = SecurityProfile(
        javaResource as
            com.pulumi.aws.connect.SecurityProfile,
    )
}

/**
 * @see [SecurityProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityProfile].
 */
public suspend fun securityProfile(
    name: String,
    block: suspend SecurityProfileResourceBuilder.() -> Unit,
): SecurityProfile {
    val builder = SecurityProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityProfile(name: String): SecurityProfile {
    val builder = SecurityProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
