@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.connect.kotlin

import com.pulumi.aws.connect.SecurityProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Amazon Connect Security Profile resource. For more information see
 * [Amazon Connect: Getting Started](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-get-started.html)
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.connect.SecurityProfile;
 * import com.pulumi.aws.connect.SecurityProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SecurityProfile("example", SecurityProfileArgs.builder()
 *             .description("example description")
 *             .instanceId("aaaaaaaa-bbbb-cccc-dddd-111111111111")
 *             .permissions(
 *                 "BasicAgentAccess",
 *                 "OutboundCallAccess")
 *             .tags(Map.of("Name", "Example Security Profile"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Amazon Connect Security Profiles using the `instance_id` and `security_profile_id` separated by a colon (`:`). For example:
 * ```sh
 *  $ pulumi import aws:connect/securityProfile:SecurityProfile example f1288a1f-6193-445a-b47e-af739b2:c1d4e5f6-1b3c-1b3c-1b3c-c1d4e5f6c1d4e5
 * ```
 * @property description Specifies the description of the Security Profile.
 * @property instanceId Specifies the identifier of the hosting Amazon Connect Instance.
 * @property name Specifies the name of the Security Profile.
 * @property permissions Specifies a list of permissions assigned to the security profile.
 * @property tags Tags to apply to the Security Profile. If configured with a provider
 * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SecurityProfileArgs(
    public val description: Output<String>? = null,
    public val instanceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val permissions: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.connect.SecurityProfileArgs> {
    override fun toJava(): com.pulumi.aws.connect.SecurityProfileArgs =
        com.pulumi.aws.connect.SecurityProfileArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceId(instanceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .permissions(permissions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SecurityProfileArgs].
 */
@PulumiTagMarker
public class SecurityProfileArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var name: Output<String>? = null

    private var permissions: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the description of the Security Profile.
     */
    @JvmName("vgicuhpvkbaabomx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("niuaxrlxhgswdyfe")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value Specifies the name of the Security Profile.
     */
    @JvmName("qcjwbjqrpdotjjsh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies a list of permissions assigned to the security profile.
     */
    @JvmName("gqnwfhqjldxisxhm")
    public suspend fun permissions(`value`: Output<List<String>>) {
        this.permissions = value
    }

    @JvmName("aepdwputhedjdrbv")
    public suspend fun permissions(vararg values: Output<String>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values Specifies a list of permissions assigned to the security profile.
     */
    @JvmName("gnosnijogqvfmcli")
    public suspend fun permissions(values: List<Output<String>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value Tags to apply to the Security Profile. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xuomxhlnulxxegkm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the description of the Security Profile.
     */
    @JvmName("toedvgostunbvrbh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the identifier of the hosting Amazon Connect Instance.
     */
    @JvmName("fsdbghhnvigjwdpu")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value Specifies the name of the Security Profile.
     */
    @JvmName("nbbpedhvtscptuwu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies a list of permissions assigned to the security profile.
     */
    @JvmName("acrinkjkhmmtwdgy")
    public suspend fun permissions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param values Specifies a list of permissions assigned to the security profile.
     */
    @JvmName("jlihvmhtewysoqvd")
    public suspend fun permissions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value Tags to apply to the Security Profile. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mtxisshjmwvjaxlg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags to apply to the Security Profile. If configured with a provider
     * `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qdtyvxrrdwhygnbd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SecurityProfileArgs = SecurityProfileArgs(
        description = description,
        instanceId = instanceId,
        name = name,
        permissions = permissions,
        tags = tags,
    )
}
